/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.impl.NonDynamicShardingEntityIndexBinding;
import org.hibernate.search.indexes.impl.EntityIndexBinder;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class NonDynamicShardingEntityIndexBinder
implements EntityIndexBinder {
    private static final Log log = LoggerFactory.make();
    private static final String INDEX_BACKEND_NAME_SEPARATOR = "#";
    private final Class<? extends IndexShardingStrategy> shardingStrategyClass;
    private final Properties[] properties;

    public NonDynamicShardingEntityIndexBinder(Class<? extends IndexShardingStrategy> shardingStrategyClass, Properties[] properties) {
        this.shardingStrategyClass = shardingStrategyClass;
        this.properties = properties;
    }

    @Override
    public MutableEntityIndexBinding bind(IndexManagerGroupHolder holder, IndexedTypeIdentifier entityType, EntityIndexingInterceptor<?> interceptor, WorkerBuildContext buildContext) {
        IndexShardingStrategy shardingStrategy = ClassLoaderHelper.instanceFromClass(IndexShardingStrategy.class, this.shardingStrategyClass, "IndexShardingStrategy");
        IndexManager[] indexManagers = this.preInitializeIndexManagersAndBackends(holder, entityType, buildContext);
        MaskedProperty maskedProperties = new MaskedProperty(this.properties[0], "sharding_strategy");
        shardingStrategy.initialize(maskedProperties, indexManagers);
        return new NonDynamicShardingEntityIndexBinding(holder, shardingStrategy, indexManagers, interceptor);
    }

    @Override
    public String createBackendIdentifier(String backendName, String indexName) {
        return indexName + INDEX_BACKEND_NAME_SEPARATOR + backendName;
    }

    private IndexManager[] preInitializeIndexManagersAndBackends(IndexManagerGroupHolder holder, IndexedTypeIdentifier entityType, WorkerBuildContext context) {
        int nbrOfIndexManagers = this.properties.length;
        if (nbrOfIndexManagers == 0) {
            throw log.entityWithNoShard(entityType);
        }
        IndexManager[] indexManagers = new IndexManager[nbrOfIndexManagers];
        for (int index = 0; index < nbrOfIndexManagers; ++index) {
            String shardIdentifier = nbrOfIndexManagers > 1 ? String.valueOf(index) : null;
            Properties indexProp = this.properties[index];
            indexManagers[index] = holder.getOrCreateIndexManager(shardIdentifier, indexProp, entityType, context);
        }
        return indexManagers;
    }
}

