/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TemporalType;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Sort;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.Session;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.IteratorImpl;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderBuilder;
import org.hibernate.search.query.hibernate.impl.ProjectionLoader;
import org.hibernate.search.query.hibernate.impl.ScrollableResultsImpl;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class FullTextQueryImpl
extends AbstractProducedQuery
implements FullTextQuery {
    private static final Log log = LoggerFactory.make();
    private ObjectLookupMethod objectLookupMethod;
    private DatabaseRetrievalMethod databaseRetrievalMethod;
    private Criteria criteria;
    private ResultTransformer resultTransformer;
    private int fetchSize = 1;
    private final HSQuery hSearchQuery;
    private final SessionImplementor session;
    private Integer firstResult;
    private Integer maxResults;
    private final Map<String, Object> hints = new HashMap<String, Object>(0);
    private static final Loader noLoader = new Loader(){

        @Override
        public void init(Session session, ExtendedSearchIntegrator extendedIntegrator, ObjectInitializer objectInitializer, TimeoutManager timeoutManager) {
        }

        @Override
        public Object load(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public Object loadWithoutTiming(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public List load(List<EntityInfo> entityInfos) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        @Override
        public boolean isSizeSafe() {
            return false;
        }
    };

    public FullTextQueryImpl(HSQuery hSearchQuery, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super((SharedSessionContractImplementor)session, parameterMetadata);
        this.session = session;
        ExtendedSearchIntegrator extendedIntegrator = this.getExtendedSearchIntegrator();
        this.objectLookupMethod = extendedIntegrator.getDefaultObjectLookupMethod();
        this.databaseRetrievalMethod = extendedIntegrator.getDefaultDatabaseRetrievalMethod();
        this.hSearchQuery = hSearchQuery;
        this.hSearchQuery.timeoutExceptionFactory((TimeoutExceptionFactory)new FullTextQueryTimeoutExceptionFactory()).tenantIdentifier(session.getTenantIdentifier());
    }

    @Override
    public FullTextQueryImpl setSort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    @Override
    @Deprecated
    public FullTextQueryImpl setFilter(Filter filter) {
        this.hSearchQuery.filter(filter);
        return this;
    }

    public List getResultList() {
        return this.list();
    }

    public Iterator iterate() {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        this.hSearchQuery.getTimeoutManager().stop();
        if (entityInfos.size() == 0) {
            IteratorImpl iterator = new IteratorImpl(entityInfos, noLoader);
            return iterator;
        }
        Loader loader = this.getLoader();
        IteratorImpl iterator = new IteratorImpl(entityInfos, loader);
        this.hSearchQuery.getTimeoutManager().stop();
        return iterator;
    }

    private Loader getLoader() {
        ObjectLoaderBuilder loaderBuilder = new ObjectLoaderBuilder().criteria(this.criteria).targetedEntities(this.hSearchQuery.getTargetedEntities()).indexedTargetedEntities(this.hSearchQuery.getIndexedTargetedEntities().toPojosSet()).session(this.session).searchFactory(this.hSearchQuery.getExtendedSearchIntegrator()).timeoutManager(this.hSearchQuery.getTimeoutManager()).lookupMethod(this.objectLookupMethod).retrievalMethod(this.databaseRetrievalMethod);
        if (this.hSearchQuery.getProjectedFields() != null) {
            return this.getProjectionLoader(loaderBuilder);
        }
        return loaderBuilder.buildLoader();
    }

    private Loader getProjectionLoader(ObjectLoaderBuilder loaderBuilder) {
        ProjectionLoader loader = new ProjectionLoader();
        loader.init((Session)this.session, this.hSearchQuery.getExtendedSearchIntegrator(), this.resultTransformer, loaderBuilder, this.hSearchQuery.getProjectedFields(), this.hSearchQuery.getTimeoutManager(), this.hSearchQuery.hasThisProjection());
        return loader;
    }

    public ScrollableResultsImpl scroll() {
        this.hSearchQuery.getTimeoutManager().start();
        DocumentExtractor documentExtractor = this.hSearchQuery.queryDocumentExtractor();
        this.hSearchQuery.getTimeoutManager().stop();
        Loader loader = this.getLoader();
        return new ScrollableResultsImpl(this.fetchSize, documentExtractor, loader, this.session, this.hSearchQuery.hasThisProjection());
    }

    public ScrollableResultsImplementor scroll(ScrollMode scrollMode) {
        return this.scroll();
    }

    public List list() {
        try {
            return this.doHibernateSearchList();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    protected List doHibernateSearchList() {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        Loader loader = this.getLoader();
        List list = loader.load(entityInfos);
        if (this.resultTransformer != null && !(loader instanceof ProjectionLoader)) {
            list = this.resultTransformer.transformList(list);
        }
        this.hSearchQuery.getTimeoutManager().stop();
        return list;
    }

    @Override
    public Explanation explain(int documentId) {
        return this.hSearchQuery.explain(documentId);
    }

    @Override
    public int getResultSize() {
        try {
            return this.doGetResultSize();
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he);
        }
    }

    public int doGetResultSize() {
        if (this.getLoader().isSizeSafe()) {
            return this.hSearchQuery.queryResultSize();
        }
        throw log.cannotGetResultSizeWithCriteriaAndRestriction(this.criteria.toString());
    }

    @Override
    public FullTextQueryImpl setCriteriaQuery(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @Override
    public FullTextQueryImpl setProjection(String ... fields) {
        this.hSearchQuery.projection(fields);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(Coordinates center, String fieldName) {
        this.hSearchQuery.setSpatialParameters(center, fieldName);
        return this;
    }

    @Override
    public FullTextQueryImpl setSpatialParameters(double latitude, double longitude, String fieldName) {
        this.setSpatialParameters((Coordinates)Point.fromDegrees((double)latitude, (double)longitude), fieldName);
        return this;
    }

    @Override
    public FullTextQuery setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("Negative (" + maxResults + ") parameter passed in to setMaxResults");
        }
        this.hSearchQuery.maxResults(maxResults);
        this.maxResults = maxResults;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults == null || this.maxResults == -1 ? Integer.MAX_VALUE : this.maxResults;
    }

    @Override
    public FullTextQuery setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.hSearchQuery.firstResult(firstResult);
        this.firstResult = firstResult;
        return this;
    }

    public int getFirstResult() {
        return this.firstResult == null ? 0 : this.firstResult;
    }

    @Override
    public FullTextQuery setHint(String hintName, Object value) {
        this.hints.put(hintName, value);
        if ("javax.persistence.query.timeout".equals(hintName) && value != null) {
            if (value instanceof String) {
                this.setTimeout(Long.parseLong((String)value), TimeUnit.MILLISECONDS);
            } else if (value instanceof Number) {
                this.setTimeout(((Number)value).longValue(), TimeUnit.MILLISECONDS);
            }
        }
        return this;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public FullTextQueryImpl setParameter(Parameter tParameter, Object t) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(Parameter calendarParameter, Calendar calendar, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(Parameter dateParameter, Date date, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(String name, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(int position, Object value) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public FullTextQueryImpl setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Set<Parameter<?>> getParameters() {
        return Collections.EMPTY_SET;
    }

    public FullTextQueryImpl setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter<?> getParameter(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter<?> getParameter(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter getParameter(String name, Class type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Parameter getParameter(int position, Class type) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public boolean isBound(Parameter param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(Parameter param) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(String name) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    public Object getParameterValue(int position) {
        throw new UnsupportedOperationException("parameters not supported in fullText queries");
    }

    @Override
    public FullTextQueryImpl setFlushMode(FlushModeType flushModeType) {
        return (FullTextQueryImpl)super.setFlushMode(flushModeType);
    }

    @Override
    public FullTextQueryImpl setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public QueryImplementor setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextQueryImpl setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        this.resultTransformer = transformer;
        return this;
    }

    public Object unwrap(Class type) {
        if (type == org.apache.lucene.search.Query.class) {
            return this.hSearchQuery.getLuceneQuery();
        }
        throw new IllegalArgumentException("Cannot unwrap " + type.getName());
    }

    public FullTextQueryImpl setLockMode(LockModeType lockModeType) {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException("lock modes not supported in fullText queries");
    }

    public LockOptions getLockOptions() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public QueryImplementor setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    protected Map getLockModes() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    public FullTextQueryImpl setTimeout(int timeout) {
        return this.setTimeout(timeout, TimeUnit.SECONDS);
    }

    @Override
    public FullTextQueryImpl setTimeout(long timeout, TimeUnit timeUnit) {
        super.setTimeout((int)timeUnit.toSeconds(timeout));
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        this.hSearchQuery.getTimeoutManager().raiseExceptionOnTimeout();
        return this;
    }

    @Override
    public FullTextQueryImpl limitExecutionTimeTo(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        this.hSearchQuery.getTimeoutManager().limitFetchingOnTimeout();
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.hSearchQuery.getTimeoutManager().hasPartialResults();
    }

    @Override
    public FullTextQueryImpl initializeObjectsWith(ObjectLookupMethod lookupMethod, DatabaseRetrievalMethod retrievalMethod) {
        this.objectLookupMethod = lookupMethod;
        this.databaseRetrievalMethod = retrievalMethod;
        return this;
    }

    private ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return ContextHelper.getSearchIntegratorBySessionImplementor(this.session);
    }

    public String getQueryString() {
        return this.hSearchQuery.getQueryString();
    }

    protected boolean isNativeQuery() {
        return false;
    }

    public Type[] getReturnTypes() {
        throw new UnsupportedOperationException("getReturnTypes() is not implemented in Hibernate Search queries");
    }

    public String[] getReturnAliases() {
        throw new UnsupportedOperationException("getReturnAliases() is not implemented in Hibernate Search queries");
    }

    public FullTextQueryImpl setEntity(int position, Object val) {
        throw new UnsupportedOperationException("setEntity(int,Object) is not implemented in Hibernate Search queries");
    }

    public FullTextQueryImpl setEntity(String name, Object val) {
        throw new UnsupportedOperationException("setEntity(String,Object) is not implemented in Hibernate Search queries");
    }

    public String toString() {
        return "FullTextQueryImpl(" + this.getQueryString() + ")";
    }

    private class FullTextQueryTimeoutExceptionFactory
    implements TimeoutExceptionFactory {
        private FullTextQueryTimeoutExceptionFactory() {
        }

        public RuntimeException createTimeoutException(String message, String queryDescription) {
            return new QueryTimeoutException(message, null, (Query)FullTextQueryImpl.this);
        }
    }
}

