/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchRequestSuccessAssessor
implements ElasticsearchRequestSuccessAssessor {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final JsonAccessor<String> ROOT_ERROR_TYPE = JsonAccessor.root().property("error").property("type").asString();
    private static final JsonAccessor<Integer> BULK_ITEM_STATUS_CODE = JsonAccessor.root().property("status").asInteger();
    private static final JsonAccessor<String> BULK_ITEM_ERROR_TYPE = JsonAccessor.root().property("error").property("type").asString();
    private static final int TIME_OUT_HTTP_STATUS_CODE = 408;
    public static final DefaultElasticsearchRequestSuccessAssessor INSTANCE = DefaultElasticsearchRequestSuccessAssessor.builder().build();
    private final Set<Integer> ignoredErrorStatuses;
    private final Set<String> ignoredErrorTypes;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultElasticsearchRequestSuccessAssessor(Builder builder) {
        this.ignoredErrorStatuses = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorStatuses));
        this.ignoredErrorTypes = Collections.unmodifiableSet(new HashSet(builder.ignoredErrorTypes));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "ignoredErrorStatuses=" + this.ignoredErrorStatuses + ", ignoredErrorTypes=" + this.ignoredErrorTypes + "]";
    }

    @Override
    public void checkSuccess(ElasticsearchWorkExecutionContext context, ElasticsearchRequest request, ElasticsearchResponse response) throws SearchException {
        JsonObject body = response.getBody();
        if (!this.isSuccess(response, body)) {
            GsonProvider gsonProvider = context.getGsonProvider();
            if (response.getStatusCode() == 408) {
                throw LOG.elasticsearchRequestTimeout(ElasticsearchClientUtils.formatRequest(gsonProvider, request), ElasticsearchClientUtils.formatResponse(gsonProvider, response));
            }
            throw LOG.elasticsearchRequestFailed(ElasticsearchClientUtils.formatRequest(gsonProvider, request), ElasticsearchClientUtils.formatResponse(gsonProvider, response), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSuccess(ElasticsearchWorkExecutionContext context, JsonObject resultItem) {
        if (resultItem == null) {
            return false;
        }
        JsonObject content = ((JsonElement)((Map.Entry)resultItem.entrySet().iterator().next()).getValue()).getAsJsonObject();
        Optional<Integer> statusCode = BULK_ITEM_STATUS_CODE.get(content);
        if (statusCode.map(c -> ElasticsearchClientUtils.isSuccessCode(c) || this.ignoredErrorStatuses.contains(c)).orElse(false) != false) return true;
        if (BULK_ITEM_ERROR_TYPE.get(content).map(this.ignoredErrorTypes::contains).orElse(false) == false) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuccess(ElasticsearchResponse response, JsonObject parsedResponseBody) {
        int code = response.getStatusCode();
        if (ElasticsearchClientUtils.isSuccessCode(code)) return true;
        if (this.ignoredErrorStatuses.contains(code)) return true;
        if (ROOT_ERROR_TYPE.get(parsedResponseBody).map(this.ignoredErrorTypes::contains).orElse(false) == false) return false;
        return true;
    }

    public static class Builder {
        private final Set<Integer> ignoredErrorStatuses = new HashSet<Integer>();
        private final Set<String> ignoredErrorTypes = new HashSet<String>();

        public Builder ignoreErrorStatuses(int ... ignoredErrorStatuses) {
            for (int ignoredErrorStatus : ignoredErrorStatuses) {
                this.ignoredErrorStatuses.add(ignoredErrorStatus);
            }
            return this;
        }

        public Builder ignoreErrorTypes(String ... ignoredErrorTypes) {
            for (String ignoredErrorType : ignoredErrorTypes) {
                this.ignoredErrorTypes.add(ignoredErrorType);
            }
            return this;
        }

        public DefaultElasticsearchRequestSuccessAssessor build() {
            return new DefaultElasticsearchRequestSuccessAssessor(this);
        }
    }
}

