/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.ExtendedSearchIntegratorWithShareableState;
import org.hibernate.search.spi.impl.TypeHierarchy;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.spi.StatisticsImplementor;

public class MutableSearchFactory
implements ExtendedSearchIntegratorWithShareableState,
SearchIntegrator,
WorkerBuildContext {
    private volatile ExtendedSearchIntegratorWithShareableState delegate;
    private final Lock mutating = new ReentrantLock();

    public void setDelegate(ExtendedSearchIntegratorWithShareableState delegate) {
        this.delegate = delegate;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.delegate.getFilterDefinitions();
    }

    @Override
    public IndexedTypeMap<EntityIndexBinding> getIndexBindings() {
        return this.delegate.getIndexBindings();
    }

    @Override
    public Worker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.delegate.getFilterCachingStrategy();
    }

    @Override
    public Map<IndexManagerType, SearchIntegration> getIntegrations() {
        return this.delegate.getIntegrations();
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.delegate.getCacheBitResultsSize();
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.delegate.getConfigurationProperties();
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.delegate.getFilterDefinition(name);
    }

    @Override
    public ExtendedSearchIntegrator getUninitializedSearchIntegrator() {
        return this;
    }

    @Override
    public IndexingMode getIndexingMode() {
        return this.delegate.getIndexingMode();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, Class<?> ... entities) {
        return this.delegate.createHSQuery(luceneQuery, entities);
    }

    @Override
    public HSQuery createHSQuery(Query luceneQuery, CustomTypeMetadata ... types) {
        return this.delegate.createHSQuery(luceneQuery, types);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.delegate.getFilterCacheBitResultsSize();
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        return this.delegate.makeBatchBackend(progressMonitor);
    }

    @Override
    public boolean isJMXEnabled() {
        return this.delegate.isJMXEnabled();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.delegate.getStatisticsImplementor();
    }

    @Override
    public TypeHierarchy getConfiguredTypeHierarchy() {
        return this.delegate.getConfiguredTypeHierarchy();
    }

    @Override
    public TypeHierarchy getIndexedTypeHierarchy() {
        return this.delegate.getIndexedTypeHierarchy();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.delegate.getServiceManager();
    }

    @Override
    public DatabaseRetrievalMethod getDefaultDatabaseRetrievalMethod() {
        return this.delegate.getDefaultDatabaseRetrievalMethod();
    }

    @Override
    public ObjectLookupMethod getDefaultObjectLookupMethod() {
        return this.delegate.getDefaultObjectLookupMethod();
    }

    @Override
    public void optimize() {
        this.delegate.optimize();
    }

    @Override
    public void optimize(IndexedTypeIdentifier entityType) {
        this.delegate.optimize(entityType);
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.delegate.getAnalyzer(name);
    }

    @Override
    public SearchIntegration getIntegration(IndexManagerType indexManagerType) {
        return this.delegate.getIntegration(indexManagerType);
    }

    @Override
    public Analyzer getAnalyzer(IndexedTypeIdentifier type) {
        return this.delegate.getAnalyzer(type);
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return this.delegate.buildQueryBuilder();
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public IndexedTypeMap<DocumentBuilderContainedEntity> getDocumentBuildersContainedEntities() {
        return this.delegate.getDocumentBuildersContainedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClasses(Class<?> ... classes) {
        SearchIntegratorBuilder builder = new SearchIntegratorBuilder().currentSearchIntegrator(this);
        for (Class<?> type : classes) {
            builder.addClass(type);
        }
        try {
            this.mutating.lock();
            builder.buildSearchIntegrator();
        }
        finally {
            this.mutating.unlock();
        }
    }

    @Override
    public boolean isDirtyChecksEnabled() {
        return this.delegate.isDirtyChecksEnabled();
    }

    @Override
    public boolean isStopped() {
        return this.delegate.isStopped();
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.delegate.isTransactionManagerExpected();
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.getIndexManagerHolder();
    }

    @Override
    public IndexManagerHolder getIndexManagerHolder() {
        return this.delegate.getIndexManagerHolder();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.delegate.getErrorHandler();
    }

    @Override
    public IndexReaderAccessor getIndexReaderAccessor() {
        return this.delegate.getIndexReaderAccessor();
    }

    @Override
    public IndexedTypeSet getIndexedTypeIdentifiers() {
        return this.delegate.getIndexedTypeIdentifiers();
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.delegate.getInstanceInitializer();
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.delegate.getDefaultTimeoutExceptionFactory();
    }

    @Override
    public TimingSource getTimingSource() {
        return this.delegate.getTimingSource();
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.delegate.getProgrammaticMapping();
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.delegate.isIndexMetadataComplete();
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.delegate.isDeleteByTermEnforced();
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.delegate.isIdProvidedImplicit();
    }

    @Override
    public boolean isMultitenancyEnabled() {
        return this.delegate.isMultitenancyEnabled();
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.delegate.getIndexManagerFactory();
    }

    @Override
    public boolean enlistWorkerInTransaction() {
        return this.delegate.enlistWorkerInTransaction();
    }

    @Override
    public IndexManager getIndexManager(String indexName) {
        return this.delegate.getIndexManager(indexName);
    }

    @Override
    public boolean isIndexUninvertingAllowed() {
        return this.delegate.isIndexUninvertingAllowed();
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        if (SearchIntegrator.class.equals(cls) || ExtendedSearchIntegrator.class.equals(cls) || MutableSearchFactory.class.equals(cls)) {
            return (T)this;
        }
        return this.delegate.unwrap(cls);
    }

    @Override
    public LuceneWorkSerializer getWorkSerializer() {
        return this.delegate.getWorkSerializer();
    }

    @Override
    public LuceneWorkSerializer getWorkSerializerState() {
        return this.delegate.getWorkSerializerState();
    }

    @Override
    public OperationDispatcher createRemoteOperationDispatcher(Predicate<IndexManager> indexManagerFilter) {
        return this.delegate.createRemoteOperationDispatcher(indexManagerFilter);
    }

    @Override
    public EntityIndexBinding getIndexBinding(IndexedTypeIdentifier entityType) {
        return this.delegate.getIndexBinding(entityType);
    }

    @Override
    public IndexedTypeSet getConfiguredTypesPolymorphic(IndexedTypeSet types) {
        return this.delegate.getConfiguredTypesPolymorphic(types);
    }

    @Override
    public IndexedTypeSet getIndexedTypesPolymorphic(IndexedTypeSet queryTarget) {
        return this.delegate.getIndexedTypesPolymorphic(queryTarget);
    }

    @Override
    public DocumentBuilderContainedEntity getDocumentBuilderContainedEntity(IndexedTypeIdentifier entityType) {
        return this.delegate.getDocumentBuilderContainedEntity(entityType);
    }

    @Override
    public ScopedAnalyzerReference getAnalyzerReference(IndexedTypeIdentifier type) {
        return this.delegate.getAnalyzerReference(type);
    }

    @Override
    public IndexedTypeDescriptor getIndexedTypeDescriptor(IndexedTypeIdentifier typeId) {
        return this.delegate.getIndexedTypeDescriptor(typeId);
    }
}

