/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.dialect.impl.DialectIndependentGsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.ElasticsearchLogCategories;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.impl.Futures;
import org.hibernate.search.util.logging.impl.LogCategory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchClient
implements ElasticsearchClientImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private static final Log requestLog = (Log)LoggerFactory.make(Log.class, (LogCategory)ElasticsearchLogCategories.REQUEST);
    private final RestClient restClient;
    private final Sniffer sniffer;
    private final ScheduledExecutorService timeoutExecutorService;
    private final int requestTimeoutValue;
    private final TimeUnit requestTimeoutUnit;
    private volatile GsonProvider gsonProvider;

    public DefaultElasticsearchClient(RestClient restClient, Sniffer sniffer, int requestTimeoutValue, TimeUnit requestTimeoutUnit) {
        this.restClient = restClient;
        this.sniffer = sniffer;
        this.timeoutExecutorService = Executors.newScheduledThreadPool((String)"Elasticsearch request timeout executor");
        this.requestTimeoutValue = requestTimeoutValue;
        this.requestTimeoutUnit = requestTimeoutUnit;
        this.gsonProvider = DialectIndependentGsonProvider.INSTANCE;
    }

    @Override
    public void init(GsonProvider gsonProvider) {
        this.gsonProvider = gsonProvider;
    }

    @Override
    public CompletableFuture<ElasticsearchResponse> submit(ElasticsearchRequest request) {
        return Futures.create(() -> this.send(request)).thenApply(response -> this.convertResponse(request, (Response)response));
    }

    private CompletableFuture<Response> send(ElasticsearchRequest request) {
        Gson gson = this.gsonProvider.getGson();
        HttpEntity entity = ElasticsearchClientUtils.toEntity(gson, request);
        long start = System.nanoTime();
        final CompletableFuture completableFuture = new CompletableFuture();
        this.restClient.performRequestAsync(request.getMethod(), request.getPath(), request.getParameters(), entity, new ResponseListener(){

            public void onSuccess(Response response) {
                completableFuture.complete(response);
            }

            public void onFailure(Exception exception) {
                if (exception instanceof ResponseException) {
                    requestLog.debug("ES client issued a ResponseException - not necessarily a problem", exception);
                    completableFuture.complete(((ResponseException)exception).getResponse());
                } else {
                    completableFuture.completeExceptionally(exception);
                }
            }
        }, new Header[0]);
        ScheduledFuture<?> timeout = this.timeoutExecutorService.schedule(() -> {
            if (!completableFuture.isDone()) {
                completableFuture.completeExceptionally(new TimeoutException());
            }
        }, (long)this.requestTimeoutValue, this.requestTimeoutUnit);
        completableFuture.thenRun(() -> timeout.cancel(false));
        return completableFuture.thenApply(response -> {
            long executionTime = System.nanoTime() - start;
            requestLog.executedRequest(request.getPath(), request.getParameters(), TimeUnit.NANOSECONDS.toMillis(executionTime));
            return response;
        });
    }

    private ElasticsearchResponse convertResponse(ElasticsearchRequest request, Response response) {
        try {
            JsonObject body = this.parseBody(response);
            return new ElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), body);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToParseElasticsearchResponse(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), e);
        }
    }

    /*
     * Exception decompiling
     */
    private JsonObject parseBody(Response response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Charset getCharset(HttpEntity entity) {
        ContentType contentType = ContentType.get((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(this.timeoutExecutorService::shutdownNow);
            if (this.sniffer != null) {
                closer.push(() -> ((Sniffer)this.sniffer).close());
            }
            closer.push(() -> ((RestClient)this.restClient).close());
        }
    }
}

