/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JsonLogHelper {
    private static final Gson GSON_PRETTY_PRINT = new GsonBuilder().setPrettyPrinting().create();

    private JsonLogHelper() {
    }

    public static String prettyPrint(JsonObject object) {
        StringBuilder stringWriter = new StringBuilder();
        JsonLogHelper.prettyPrint(stringWriter, object);
        return stringWriter.toString();
    }

    public static void prettyPrint(StringBuilder sb, JsonObject object) {
        try {
            GSON_PRETTY_PRINT.toJson((JsonElement)object, (Appendable)sb);
        }
        catch (RuntimeException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            sb.append(writer.toString());
        }
    }

    public static String prettyPrint(Iterable<JsonObject> objects) {
        StringBuilder sb = new StringBuilder(180);
        JsonLogHelper.prettyPrint(sb, objects);
        return sb.toString();
    }

    public static void prettyPrint(StringBuilder sb, Iterable<JsonObject> objects) {
        for (JsonObject object : objects) {
            JsonLogHelper.prettyPrint(sb, object);
            sb.append("\n");
        }
    }

    public static JsonElement property(JsonObject parent, String name) {
        if (parent == null) {
            return null;
        }
        return parent.get(name);
    }

    public static String propertyAsString(JsonElement parent, String name) {
        if (parent == null || !parent.isJsonObject()) {
            return null;
        }
        JsonElement propretyValue = JsonLogHelper.property(parent.getAsJsonObject(), name);
        if (propretyValue == null) {
            return null;
        }
        return propretyValue.toString();
    }
}

