/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.aws.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.hibernate.search.elasticsearch.spi.DigestSelfSigningCapable;

class AWSPayloadHashingRequestInterceptor
implements HttpRequestInterceptor {
    public static final String CONTEXT_ATTRIBUTE_HASH = AWSPayloadHashingRequestInterceptor.class.getName() + "_hash";

    AWSPayloadHashingRequestInterceptor() {
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String contentHash = this.computeContentHash(request);
        context.setAttribute(CONTEXT_ATTRIBUTE_HASH, (Object)contentHash);
    }

    private String computeContentHash(HttpRequest request) throws IOException {
        HttpEntity entity = this.getEntity(request);
        if (entity == null) {
            return DigestUtils.sha256Hex((String)"");
        }
        if (entity instanceof DigestSelfSigningCapable) {
            DigestSelfSigningCapable e = (DigestSelfSigningCapable)entity;
            MessageDigest digest = DigestUtils.getSha256Digest();
            e.fillDigest(digest);
            return Hex.encodeHexString((byte[])digest.digest());
        }
        if (!entity.isRepeatable()) {
            throw new IllegalStateException("Cannot sign AWS requests with non-repeatable entities");
        }
        try (InputStream content = entity.getContent();){
            String string = DigestUtils.sha256Hex((InputStream)content);
            return string;
        }
    }

    private HttpEntity getEntity(HttpRequest request) throws IOException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return ((HttpEntityEnclosingRequest)request).getEntity();
        }
        return null;
    }
}

