/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchSchemaCreator
implements ElasticsearchSchemaCreator {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchSchemaAccessor schemaAccessor;

    public DefaultElasticsearchSchemaCreator(ElasticsearchSchemaAccessor schemaAccessor) {
        this.schemaAccessor = schemaAccessor;
    }

    @Override
    public void createIndex(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        this.schemaAccessor.createIndex(indexName, indexMetadata.getSettings(), executionOptions);
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
    }

    @Override
    public boolean createIndexIfAbsent(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        boolean created = false;
        if (!this.schemaAccessor.indexExists(indexName)) {
            created = this.schemaAccessor.createIndexIfAbsent(indexName, indexMetadata.getSettings(), executionOptions);
        }
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
        return created;
    }

    @Override
    public void checkIndexExists(URLEncodedString indexName, ExecutionOptions executionOptions) {
        if (!this.schemaAccessor.indexExists(indexName)) {
            throw LOG.indexMissing(indexName);
        }
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
    }

    @Override
    public void createMappings(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        URLEncodedString indexName = indexMetadata.getName();
        for (Map.Entry<String, TypeMapping> entry : indexMetadata.getMappings().entrySet()) {
            URLEncodedString mappingName = URLEncodedString.fromString(entry.getKey());
            TypeMapping mapping = entry.getValue();
            this.schemaAccessor.putMapping(indexName, mappingName, mapping);
        }
    }
}

