/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.BarrierElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.util.logging.impl.LoggerFactory;

abstract class AbstractBarrierElasticsearchWorkOrchestrator
implements BarrierElasticsearchWorkOrchestrator,
AutoCloseable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private boolean open = true;
    private final ReadWriteLock shutdownLock = new ReentrantReadWriteLock();

    protected AbstractBarrierElasticsearchWorkOrchestrator(String name) {
        this.name = name;
    }

    protected final String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<Void> submit(Iterable<ElasticsearchWork<?>> works) {
        if (!this.shutdownLock.readLock().tryLock()) {
            throw LOG.orchestratorShutDownBeforeSubmittingChangeset(this.name);
        }
        try {
            if (!this.open) {
                throw LOG.orchestratorShutDownBeforeSubmittingChangeset(this.name);
            }
            CompletableFuture<Void> completableFuture = this.doSubmit(works);
            return completableFuture;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw LOG.threadInterruptedWhileSubmittingChangeset(this.name);
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }

    protected abstract CompletableFuture<Void> doSubmit(Iterable<ElasticsearchWork<?>> var1) throws InterruptedException;

    @Override
    public void close() {
        this.shutdownLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.doClose();
        }
        finally {
            this.shutdownLock.writeLock().unlock();
        }
    }

    protected abstract void doClose();
}

