/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParametersTransformer;
import org.hibernate.search.elasticsearch.settings.impl.translation.SolrSynonymsParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.translation.WordnetSynonymsParameterValueTransformer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class SynonymsParametersTransformer
implements ParametersTransformer {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String SOLR_FORMAT = "solr";
    private static final String WORDNET_FORMAT = "wordnet";
    private final Class<?> factoryClass;
    private final ParameterValueTransformer solrSynonymsTransformer;
    private final ParameterValueTransformer wordnetSynonymsTransformer;

    public SynonymsParametersTransformer(Class<?> factoryClass, ResourceLoader resourceLoader) {
        this.factoryClass = factoryClass;
        this.solrSynonymsTransformer = new SolrSynonymsParameterValueTransformer(resourceLoader);
        this.wordnetSynonymsTransformer = new WordnetSynonymsParameterValueTransformer(resourceLoader);
    }

    @Override
    public Map<String, JsonElement> transform(Map<String, String> luceneParameters) {
        LinkedHashMap<String, JsonElement> result = new LinkedHashMap<String, JsonElement>();
        String format = luceneParameters.remove("format");
        if (format != null) {
            result.put("format", (JsonElement)new JsonPrimitive(format));
        } else {
            format = SOLR_FORMAT;
        }
        String fileNames = luceneParameters.remove("synonyms");
        if (fileNames != null) {
            ParameterValueTransformer synonymsTransformer = this.getSynonymsTransformer(format);
            JsonElement synonyms = synonymsTransformer.transform(fileNames);
            result.put("synonyms", synonyms);
        }
        return result;
    }

    private ParameterValueTransformer getSynonymsTransformer(String format) {
        switch (format) {
            case "solr": {
                return this.solrSynonymsTransformer;
            }
            case "wordnet": {
                return this.wordnetSynonymsTransformer;
            }
        }
        throw LOG.unsupportedAnalysisDefinitionParameterValue(this.factoryClass, "format", format);
    }
}

