/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.beans.Introspector;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.impl.ImmutableSearchIntegration;
import org.hibernate.search.engine.impl.MappingDefinitionRegistry;
import org.hibernate.search.engine.impl.MutableAnalyzerRegistry;
import org.hibernate.search.engine.impl.MutableNormalizerRegistry;
import org.hibernate.search.engine.impl.SearchIntegrationConfigContext;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ConfigContext {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private static final String DEFAULT_NULL_INDEX_TOKEN = "_null_";
    private final MappingDefinitionRegistry<AnalyzerDef, AnalyzerDef> analyzerDefinitionRegistry = new MappingDefinitionRegistry(Function.identity(), LOG::analyzerDefinitionNamingConflict);
    private final MappingDefinitionRegistry<NormalizerDef, NormalizerDef> normalizerDefinitionRegistry = new MappingDefinitionRegistry<NormalizerDef, NormalizerDef>(this::interpretNormalizerDef, LOG::normalizerDefinitionNamingConflict);
    private final MappingDefinitionRegistry<FullTextFilterDef, FilterDef> fullTextFilterDefinitionRegistry = new MappingDefinitionRegistry<FullTextFilterDef, FilterDef>(this::interpretFullTextFilterDef, LOG::fullTextFilterDefinitionNamingConflict);
    private final Map<IndexManagerType, SearchIntegrationConfigContext> indexManagerTypeConfigContexts = new HashMap<IndexManagerType, SearchIntegrationConfigContext>();
    private final boolean jpaPresent;
    private final String nullToken;
    private final boolean implicitProvidedId;
    private final SearchMapping searchMapping;
    private final ServiceManager serviceManager;
    private final SearchConfiguration searchConfiguration;

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext) {
        this(searchConfiguration, buildContext, null, null);
    }

    public ConfigContext(SearchConfiguration searchConfiguration, BuildContext buildContext, SearchMapping searchMapping, Map<IndexManagerType, SearchIntegration> previousSearchIntegrations) {
        this.serviceManager = buildContext.getServiceManager();
        this.jpaPresent = searchConfiguration.isJPAAnnotationsProcessingEnabled();
        this.nullToken = this.initNullToken(searchConfiguration);
        this.implicitProvidedId = searchConfiguration.isIdProvidedImplicit();
        this.searchMapping = searchMapping;
        this.searchConfiguration = searchConfiguration;
        if (previousSearchIntegrations != null) {
            for (Map.Entry<IndexManagerType, SearchIntegration> entry : previousSearchIntegrations.entrySet()) {
                IndexManagerType type = entry.getKey();
                SearchIntegration integrationState = entry.getValue();
                SearchIntegrationConfigContext context = new SearchIntegrationConfigContext(type, this.serviceManager, searchConfiguration, integrationState);
                this.indexManagerTypeConfigContexts.put(type, context);
            }
        }
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public MappingDefinitionRegistry<AnalyzerDef, ?> getAnalyzerDefinitionRegistry() {
        return this.analyzerDefinitionRegistry;
    }

    public MappingDefinitionRegistry<NormalizerDef, ?> getNormalizerDefinitionRegistry() {
        return this.normalizerDefinitionRegistry;
    }

    public MappingDefinitionRegistry<FullTextFilterDef, ?> getFullTextFilterDefinitionRegistry() {
        return this.fullTextFilterDefinitionRegistry;
    }

    public SearchIntegrationConfigContext forType(IndexManagerType type) {
        SearchIntegrationConfigContext context = this.indexManagerTypeConfigContexts.get(type);
        if (context == null) {
            context = new SearchIntegrationConfigContext(type, this.serviceManager, this.searchConfiguration);
            this.indexManagerTypeConfigContexts.put(type, context);
        }
        return context;
    }

    private String initNullToken(SearchConfiguration cfg) {
        String defaultNullIndexToken = cfg.getProperty("hibernate.search.default_null_token");
        if (StringHelper.isEmpty(defaultNullIndexToken)) {
            defaultNullIndexToken = DEFAULT_NULL_INDEX_TOKEN;
        }
        return defaultNullIndexToken;
    }

    public String getDefaultNullToken() {
        return this.nullToken;
    }

    private NormalizerDef interpretNormalizerDef(NormalizerDef normalizerDef) {
        if (normalizerDef.charFilters().length == 0 && normalizerDef.filters().length == 0) {
            throw LOG.invalidEmptyNormalizerDefinition(normalizerDef.name());
        }
        return normalizerDef;
    }

    private FilterDef interpretFullTextFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            return filterDef;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        return filterDef;
    }

    public Map<IndexManagerType, SearchIntegration> initIntegrations(IndexManagerHolder indexesFactory) {
        Object registry;
        Map<String, AnalyzerDef> mappingAnalyzerDefs = this.analyzerDefinitionRegistry.getAll();
        Map<String, NormalizerDef> mappingNormalizerDefs = this.normalizerDefinitionRegistry.getAll();
        for (String name : mappingAnalyzerDefs.keySet()) {
            if (this.hasAnalyzerReference(name)) continue;
            registry = this.forType(LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerRegistry();
            ((MutableAnalyzerRegistry)registry).getOrCreateAnalyzerReference(name);
        }
        for (String name : mappingNormalizerDefs.keySet()) {
            if (this.hasNormalizerReference(name)) continue;
            registry = this.forType(LuceneEmbeddedIndexManagerType.INSTANCE).getNormalizerRegistry();
            ((MutableNormalizerRegistry)registry).getOrCreateNamedNormalizerReference(name);
        }
        HashSet<IndexManagerType> indexManagerTypes = new HashSet<IndexManagerType>();
        indexManagerTypes.addAll(indexesFactory.getIndexManagerTypes());
        indexManagerTypes.addAll(this.indexManagerTypeConfigContexts.keySet());
        HashMap<IndexManagerType, SearchIntegration> immutableSearchIntegrations = new HashMap<IndexManagerType, SearchIntegration>(indexManagerTypes.size());
        for (IndexManagerType indexManagerType : indexManagerTypes) {
            ImmutableSearchIntegration searchIntegration = this.forType(indexManagerType).initialize(mappingAnalyzerDefs, mappingNormalizerDefs);
            immutableSearchIntegrations.put(indexManagerType, searchIntegration);
        }
        return immutableSearchIntegrations;
    }

    private boolean hasAnalyzerReference(String name) {
        for (SearchIntegrationConfigContext context : this.indexManagerTypeConfigContexts.values()) {
            MutableAnalyzerRegistry registry = context.getAnalyzerRegistry();
            if (!registry.getNamedAnalyzerReferences().containsKey(name)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNormalizerReference(String name) {
        for (SearchIntegrationConfigContext context : this.indexManagerTypeConfigContexts.values()) {
            MutableNormalizerRegistry registry = context.getNormalizerRegistry();
            if (!registry.getNamedNormalizerReferences().containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Map<String, FilterDef> initFilters() {
        return this.fullTextFilterDefinitionRegistry.getAll();
    }

    public boolean isJpaPresent() {
        return this.jpaPresent;
    }

    public boolean isProvidedIdImplicit() {
        return this.implicitProvidedId;
    }

    public Map<FieldBridge, ClassBridge> getClassBridgeInstances(Class<?> type) {
        EntityDescriptor entityDescriptor;
        Map<FieldBridge, ClassBridge> classBridgeInstances = null;
        if (this.searchMapping != null && (entityDescriptor = this.searchMapping.getEntityDescriptor(type)) != null) {
            classBridgeInstances = entityDescriptor.getClassBridgeConfigurations();
        }
        return classBridgeInstances != null ? classBridgeInstances : Collections.emptyMap();
    }
}

