/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.context.jpa.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.jsr352.context.jpa.impl.MutableSessionFactoryRegistry;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ActiveSessionFactoryRegistry
implements MutableSessionFactoryRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final MutableSessionFactoryRegistry INSTANCE = new ActiveSessionFactoryRegistry();
    private static final String PERSISTENCE_UNIT_NAME_NAMESPACE = "persistence-unit-name";
    private static final String SESSION_FACTORY_NAME_NAMESPACE = "session-factory-name";
    private final Collection<SessionFactoryImplementor> sessionFactories = new HashSet<SessionFactoryImplementor>();
    private final ConcurrentMap<String, SessionFactoryImplementor> sessionFactoriesByPUName = new ConcurrentHashMap<String, SessionFactoryImplementor>();
    private final ConcurrentMap<String, SessionFactoryImplementor> sessionFactoriesByName = new ConcurrentHashMap<String, SessionFactoryImplementor>();

    public static MutableSessionFactoryRegistry getInstance() {
        return INSTANCE;
    }

    private ActiveSessionFactoryRegistry() {
    }

    @Override
    public synchronized void register(SessionFactoryImplementor sessionFactory) {
        String name;
        this.sessionFactories.add(sessionFactory);
        Object persistenceUnitName = sessionFactory.getProperties().get("hibernate.ejb.persistenceUnitName");
        if (persistenceUnitName instanceof String) {
            this.sessionFactoriesByPUName.put((String)persistenceUnitName, sessionFactory);
        }
        if ((name = sessionFactory.getName()) != null) {
            this.sessionFactoriesByName.put(name, sessionFactory);
        }
    }

    @Override
    public synchronized void unregister(SessionFactoryImplementor sessionFactory) {
        this.sessionFactories.remove(sessionFactory);
        this.sessionFactoriesByPUName.values().remove(sessionFactory);
        this.sessionFactoriesByName.values().remove(sessionFactory);
    }

    @Override
    public synchronized EntityManagerFactory getDefault() {
        if (this.sessionFactories.isEmpty()) {
            throw log.noEntityManagerFactoryCreated();
        }
        if (this.sessionFactories.size() > 1) {
            throw log.tooManyActiveEntityManagerFactories();
        }
        return (EntityManagerFactory)this.sessionFactories.iterator().next();
    }

    @Override
    public EntityManagerFactory get(String reference) {
        return this.get(PERSISTENCE_UNIT_NAME_NAMESPACE, reference);
    }

    @Override
    public EntityManagerFactory get(String namespace, String reference) {
        SessionFactory factory;
        switch (namespace) {
            case "persistence-unit-name": {
                factory = (SessionFactory)this.sessionFactoriesByPUName.get(reference);
                if (factory != null) break;
                throw log.cannotFindEntityManagerFactoryByPUName(reference);
            }
            case "session-factory-name": {
                factory = (SessionFactory)this.sessionFactoriesByName.get(reference);
                if (factory != null) break;
                throw log.cannotFindEntityManagerFactoryByName(reference);
            }
            default: {
                throw log.unknownEntityManagerFactoryNamespace(namespace);
            }
        }
        return factory;
    }
}

