/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.logging.impl;

import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.BaseHibernateSearchLogger;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends BaseHibernateSearchLogger {
    public static final int JSR_352_MESSAGES_START_ID = 500000;

    @Message(id=500001, value="An 'entityManagerFactoryNamespace' parameter was defined, but the 'entityManagerFactoryReference' parameter is empty. Please also set the 'entityManagerFactoryReference' parameter to select an entity manager factory, or do not set the 'entityManagerFactoryNamespace' parameter to try to use a default entity manager factory.")
    public SearchException entityManagerFactoryReferenceIsEmpty();

    @Message(id=500002, value="No entity manager factory available in the CDI context with this bean name: '%1$s'. Make sure your entity manager factory is a named bean.")
    public SearchException noAvailableEntityManagerFactoryInCDI(String var1);

    @Message(id=500003, value="Unknown entity manager factory namespace: '%1$s'. Please use a supported namespace.")
    public SearchException unknownEntityManagerFactoryNamespace(String var1);

    @Message(id=500004, value="Exception while retrieving the EntityManagerFactory using @PersistenceUnit. This generally happens either because the persistence wasn't configured properly or because there are multiple persistence units.")
    public SearchException cannotRetrieveEntityManagerFactoryInJsr352();

    @Message(id=500005, value="Multiple entity manager factories have been registered in the CDI context. Please provide the bean name for the selected entity manager factory to the batch indexing job through the 'entityManagerFactoryReference' parameter.")
    public SearchException ambiguousEntityManagerFactoryInJsr352();

    @Message(id=500006, value="No entity manager factory has been created with this persistence unit name yet: '%1$s'. Make sure you use the JPA API to create your entity manager factory (use a 'persistence.xml' file) and that the entity manager factory has already been created and wasn't closed before you launch the job.")
    public SearchException cannotFindEntityManagerFactoryByPUName(String var1);

    @Message(id=500007, value="No entity manager factory has been created with this name yet: '%1$s'. Make sure your entity manager factory is named (for instance by setting the 'hibernate.session_factory_name' option) and that the entity manager factory has already been created and wasn't closed before you launch the job.")
    public SearchException cannotFindEntityManagerFactoryByName(String var1);

    @Message(id=500008, value="No entity manager factory has been created yet. Make sure that the entity manager factory has already been created and wasn't closed before you launched the job.")
    public SearchException noEntityManagerFactoryCreated();

    @Message(id=500009, value="Multiple entity manager factories are currently active. Please provide the name of the selected persistence unit to the batch indexing job through the 'entityManagerFactoryReference' parameter (you may also use the 'entityManagerFactoryNamespace' parameter for more referencing options).")
    public SearchException tooManyActiveEntityManagerFactories();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=500010, value="%1$s")
    public void analyzeIndexProgress(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=500015, value="Optimizing all entities ...")
    public void startOptimization();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500016, value="%1$d criteria found.")
    public void criteriaSize(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500017, value="Checkpoint reached. Sending checkpoint ID to batch runtime... (entity='%1$s', checkpointInfo='%2$s')")
    public void checkpointReached(String var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500018, value="Opening EntityReader of partitionId='%1$s', entity='%2$s'.")
    public void openingReader(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500019, value="Closing EntityReader of partitionId='%1$s', entity='%2$s'.")
    public void closingReader(String var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=500021, value="Reading entity...")
    public void readingEntity();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=500022, value="No more results, read ends.")
    public void noMoreResults();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=500023, value="Processing entity with id: '%1$s'")
    public void processEntity(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500024, value="Opening LuceneDocWriter of partitionId='%1$s', entity='%2$s'.")
    public void openingDocWriter(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=500025, value="Closing LuceneDocWriter of partitionId='%1$s', entity='%2$s'.")
    public void closingDocWriter(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=500026, value="%1$d partitions, %2$d threads.")
    public void partitionsPlan(int var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=500027, value="entityName: '%1$s', rowsToIndex: %2$d")
    public void rowsToIndex(String var1, Long var2);

    @Message(id=500028, value="Failed to serialize job parameter of type %1$s")
    public SearchException failedToSerializeJobParameter(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Cause Throwable var2);

    @Message(id=500029, value="Unable to parse value '%2$s' for job parameter '%1$s'.")
    public SearchException unableToParseJobParameter(String var1, Object var2, @Cause Exception var3);

    @Message(id=500030, value="The value of parameter 'checkpointInterval' (value=%1$d) should be equal to or less than the value of parameter 'rowsPerPartition' (value=%2$d).")
    public SearchException illegalCheckpointInterval(int var1, int var2);

    @Message(id=500031, value="The value of parameter '%1$s' (value=%2$d) should be greater than 0.")
    public SearchException negativeValueOrZero(String var1, Number var2);

    @Message(id=500032, value="The following selected entity types aren't indexable: %1$s. Please check if the annotation '@Indexed' has been added to each of them.")
    public SearchException failingEntityTypes(String var1);

    @Message(id=500033, value="The value of parameter 'sessionClearInterval' (value=%1$d) should be equal to or less than the value of parameter 'checkpointInterval' (value=%2$d).")
    public SearchException illegalSessionClearInterval(int var1, int var2);
}

