/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.jsr352.massindexing.impl.util.EntityTypeDescriptor;

public class JobContextData {
    private EntityManagerFactory entityManagerFactory;
    private Map<String, EntityTypeDescriptor> entityTypeDescriptorMap = new HashMap<String, EntityTypeDescriptor>();
    private Set<Criterion> customQueryCriteria;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public ExtendedSearchIntegrator getSearchIntegrator() {
        return ContextHelper.getSearchIntegratorBySF((SessionFactory)((SessionFactory)this.entityManagerFactory.unwrap(SessionFactory.class)));
    }

    public void setEntityTypeDescriptors(Iterable<EntityTypeDescriptor> descriptors) {
        descriptors.forEach(descriptor -> this.entityTypeDescriptorMap.put(descriptor.getJavaClass().getName(), (EntityTypeDescriptor)descriptor));
    }

    public EntityTypeDescriptor getEntityTypeDescriptor(String entityName) {
        EntityTypeDescriptor descriptor = this.entityTypeDescriptorMap.get(entityName);
        if (descriptor == null) {
            String msg = String.format(Locale.ROOT, "entity type %s not found.", entityName);
            throw new NoSuchElementException(msg);
        }
        return descriptor;
    }

    public EntityTypeDescriptor getEntityTypeDescriptor(Class<?> entityType) {
        return this.getEntityTypeDescriptor(entityType.getName());
    }

    public List<EntityTypeDescriptor> getEntityTypeDescriptors() {
        return this.entityTypeDescriptorMap.values().stream().collect(Collectors.toList());
    }

    public List<Class<?>> getEntityTypes() {
        return this.entityTypeDescriptorMap.values().stream().map(EntityTypeDescriptor::getJavaClass).collect(Collectors.toList());
    }

    public Class<?> getEntityType(String entityName) {
        return this.getEntityTypeDescriptor(entityName).getJavaClass();
    }

    public Set<Criterion> getCustomQueryCriteria() {
        return this.customQueryCriteria;
    }

    public void setCustomQueryCriteria(Set<Criterion> criteria) {
        this.customQueryCriteria = criteria;
    }

    public String toString() {
        return "JobContextData [" + "entityManagerFactory=" + this.entityManagerFactory + ", entityTypeDescriptorMap=" + this.entityTypeDescriptorMap + ", customQueryCriteria=" + this.customQueryCriteria + "]";
    }
}

