/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl;

import javax.batch.api.BatchProperty;
import javax.batch.api.listener.AbstractJobListener;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.hibernate.Criteria;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.jsr352.context.jpa.spi.EntityManagerFactoryRegistry;
import org.hibernate.search.jsr352.inject.scope.spi.HibernateSearchJobScoped;
import org.hibernate.search.jsr352.massindexing.MassIndexingJobParameters;
import org.hibernate.search.jsr352.massindexing.impl.util.JobContextUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.ValidationUtil;
import org.hibernate.search.util.StringHelper;

@Named(value="org.hibernate.search.jsr352.massindexing.impl.JobContextSetupListener")
@HibernateSearchJobScoped
public class JobContextSetupListener
extends AbstractJobListener {
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="entityManagerFactoryNamespace")
    private String entityManagerFactoryNamespace;
    @Inject
    @BatchProperty(name="entityManagerFactoryReference")
    private String entityManagerFactoryReference;
    @Inject
    @BatchProperty(name="entityTypes")
    private String serializedEntityTypes;
    @Inject
    @BatchProperty(name="maxThreads")
    private String serializedMaxThreads;
    @Inject
    @BatchProperty(name="maxResultsPerEntity")
    private String serializedMaxResultsPerEntity;
    @Inject
    @BatchProperty(name="idFetchSize")
    private String serializedIdFetchSize;
    @Inject
    @BatchProperty(name="entityFetchSize")
    private String serializedEntityFetchSize;
    @Inject
    @BatchProperty(name="cacheMode")
    private String serializedCacheMode;
    @Inject
    @BatchProperty(name="optimizeOnFinish")
    private String serializedOptimizedOnFinish;
    @Inject
    @BatchProperty(name="optimizeAfterPurge")
    private String serializedOptimizedAfterPurge;
    @Inject
    @BatchProperty(name="purgeAllOnStart")
    private String serializedPurgeAllOnStart;
    @Inject
    @BatchProperty(name="checkpointInterval")
    private String serializedCheckpointInterval;
    @Inject
    @BatchProperty(name="sessionClearInterval")
    private String serializedSessionClearInterval;
    @Inject
    @BatchProperty(name="rowsPerPartition")
    private String serializedRowsPerPartition;
    @Inject
    @BatchProperty(name="customQueryCriteria")
    private String serializedCustomQueryCriteria;
    @Inject
    private EntityManagerFactoryRegistry emfRegistry;

    public void beforeJob() throws Exception {
        this.validateParameters();
        JobContextUtil.getOrCreateData(this.jobContext, this.emfRegistry, this.entityManagerFactoryNamespace, this.entityManagerFactoryReference, this.serializedEntityTypes, this.serializedCustomQueryCriteria);
    }

    private void validateParameters() throws SearchException {
        this.validateEntityTypes();
        this.validateQuerying();
        this.validateChunkSettings();
        this.validateJobSettings();
    }

    private void validateEntityTypes() {
        ValidationUtil.validateEntityTypes(this.emfRegistry, this.entityManagerFactoryNamespace, this.entityManagerFactoryReference, this.serializedEntityTypes);
    }

    private void validateChunkSettings() {
        Integer rowsPerPartition = SerializationUtil.parseIntegerParameterOptional("rowsPerPartition", this.serializedRowsPerPartition, 20000);
        Integer checkpointIntervalRaw = SerializationUtil.parseIntegerParameterOptional("checkpointInterval", this.serializedCheckpointInterval, null);
        int checkpointInterval = MassIndexingJobParameters.Defaults.checkpointInterval(checkpointIntervalRaw, rowsPerPartition);
        Integer sessionClearIntervalRaw = SerializationUtil.parseIntegerParameterOptional("sessionClearInterval", this.serializedSessionClearInterval, null);
        int sessionClearInterval = MassIndexingJobParameters.Defaults.sessionClearInterval(sessionClearIntervalRaw, checkpointInterval);
        ValidationUtil.validatePositive("sessionClearInterval", sessionClearInterval);
        ValidationUtil.validatePositive("checkpointInterval", checkpointInterval);
        ValidationUtil.validatePositive("rowsPerPartition", rowsPerPartition);
        ValidationUtil.validateCheckpointInterval(checkpointInterval, rowsPerPartition);
        ValidationUtil.validateSessionClearInterval(sessionClearInterval, checkpointInterval);
    }

    private void validateJobSettings() {
        if (StringHelper.isNotEmpty((String)this.serializedMaxThreads)) {
            int maxThreads = SerializationUtil.parseIntegerParameter("maxThreads", this.serializedMaxThreads);
            ValidationUtil.validatePositive("maxThreads", maxThreads);
        }
        SerializationUtil.parseBooleanParameterOptional("optimizeOnFinish", this.serializedOptimizedOnFinish, true);
        SerializationUtil.parseBooleanParameterOptional("optimizeAfterPurge", this.serializedOptimizedAfterPurge, true);
        SerializationUtil.parseBooleanParameterOptional("purgeAllOnStart", this.serializedPurgeAllOnStart, true);
    }

    private void validateQuerying() {
        SerializationUtil.parseIntegerParameterOptional("idFetchSize", this.serializedIdFetchSize, 1000);
        if (StringHelper.isNotEmpty((String)this.serializedEntityFetchSize)) {
            SerializationUtil.parseIntegerParameter("entityFetchSize", this.serializedEntityFetchSize);
        }
        if (StringHelper.isNotEmpty((String)this.serializedMaxResultsPerEntity)) {
            int maxResultsPerEntity = SerializationUtil.parseIntegerParameter("maxResultsPerEntity", this.serializedMaxResultsPerEntity);
            ValidationUtil.validatePositive("maxResultsPerEntity", maxResultsPerEntity);
        }
        SerializationUtil.parseCacheModeParameter("cacheMode", this.serializedCacheMode, MassIndexingJobParameters.Defaults.CACHE_MODE);
        if (StringHelper.isNotEmpty((String)this.serializedCustomQueryCriteria)) {
            SerializationUtil.parseParameter(Criteria.class, "customQueryHQL", this.serializedCustomQueryCriteria);
        }
    }
}

