/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.afterchunk;

import java.lang.invoke.MethodHandles;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AfterChunkBatchlet
extends AbstractBatchlet {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="optimizeOnFinish")
    private String serializedOptimizeOnFinish;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;
    private Session session;

    public String process() throws Exception {
        boolean optimizeOnFinish = SerializationUtil.parseBooleanParameterOptional("optimizeOnFinish", this.serializedOptimizeOnFinish, true);
        if (optimizeOnFinish) {
            log.startOptimization();
            JobContextData jobData = (JobContextData)this.jobContext.getTransientUserData();
            EntityManagerFactory emf = jobData.getEntityManagerFactory();
            this.session = PersistenceUtil.openSession(emf, this.tenantId);
            ContextHelper.getSearchIntegrator((Session)this.session).optimize();
        }
        return null;
    }

    public void stop() throws Exception {
        this.session.close();
    }
}

