/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.beforechunk;

import java.lang.invoke.MethodHandles;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BeforeChunkBatchlet
extends AbstractBatchlet {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="purgeAllOnStart")
    private String serializedPurgeAllOnStart;
    @Inject
    @BatchProperty(name="optimizeAfterPurge")
    private String serializedOptimizeAfterPurge;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;

    public String process() throws Exception {
        boolean purgeAllOnStart = SerializationUtil.parseBooleanParameterOptional("purgeAllOnStart", this.serializedPurgeAllOnStart, true);
        boolean optimizeAfterPurge = SerializationUtil.parseBooleanParameterOptional("optimizeAfterPurge", this.serializedOptimizeAfterPurge, true);
        if (purgeAllOnStart) {
            JobContextData jobData = (JobContextData)this.jobContext.getTransientUserData();
            EntityManagerFactory emf = jobData.getEntityManagerFactory();
            try (Session session = PersistenceUtil.openSession(emf, this.tenantId);){
                FullTextSession fts = Search.getFullTextSession((Session)session);
                jobData.getEntityTypes().forEach(clz -> fts.purgeAll(clz));
                fts.flushToIndexes();
                if (optimizeAfterPurge) {
                    log.startOptimization();
                    fts.getSearchFactory().optimize();
                }
            }
        }
        return null;
    }
}

