/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemReader;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.query.Query;
import org.hibernate.search.jsr352.context.jpa.spi.EntityManagerFactoryRegistry;
import org.hibernate.search.jsr352.inject.scope.spi.HibernateSearchPartitionScoped;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.MassIndexingJobParameters;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.IndexScope;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.PartitionContextData;
import org.hibernate.search.jsr352.massindexing.impl.util.EntityTypeDescriptor;
import org.hibernate.search.jsr352.massindexing.impl.util.IdOrder;
import org.hibernate.search.jsr352.massindexing.impl.util.JobContextUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

@Named(value="org.hibernate.search.jsr352.massindexing.impl.steps.lucene.EntityReader")
@HibernateSearchPartitionScoped
public class EntityReader
extends AbstractItemReader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="entityManagerFactoryNamespace")
    private String entityManagerFactoryNamespace;
    @Inject
    @BatchProperty(name="entityManagerFactoryReference")
    private String entityManagerFactoryReference;
    @Inject
    @BatchProperty(name="entityTypes")
    private String serializedEntityTypes;
    @Inject
    @BatchProperty(name="customQueryCriteria")
    private String serializedCustomQueryCriteria;
    @Inject
    private EntityManagerFactoryRegistry emfRegistry;
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty(name="cacheMode")
    private String serializedCacheMode;
    @Inject
    @BatchProperty(name="entityName")
    private String entityName;
    @Inject
    @BatchProperty(name="entityFetchSize")
    private String serializedEntityFetchSize;
    @Inject
    @BatchProperty(name="checkpointInterval")
    private String serializedCheckpointInterval;
    @Inject
    @BatchProperty(name="sessionClearInterval")
    private String serializedSessionClearInterval;
    @Inject
    @BatchProperty(name="customQueryHQL")
    private String customQueryHql;
    @Inject
    @BatchProperty(name="maxResultsPerEntity")
    private String serializedMaxResultsPerEntity;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;
    @Inject
    @BatchProperty(name="partitionId")
    private String serializedPartitionId;
    @Inject
    @BatchProperty(name="lowerBound")
    private String serializedLowerBound;
    @Inject
    @BatchProperty(name="upperBound")
    private String serializedUpperBound;
    @Inject
    @BatchProperty(name="indexScope")
    private String indexScopeName;
    private JobContextData jobData;
    private EntityManagerFactory emf;
    private ChunkState chunkState;

    public EntityReader() {
    }

    EntityReader(String serializedCacheMode, String entityName, String serializedEntityFetchSize, String serializedCheckpointInterval, String serializedSessionClearInterval, String hql, String serializedMaxResultsPerEntity, String partitionIdStr, String serializedLowerBound, String serializedUpperBound, String indexScopeName) {
        this.serializedCacheMode = serializedCacheMode;
        this.entityName = entityName;
        this.serializedEntityFetchSize = serializedEntityFetchSize;
        this.serializedCheckpointInterval = serializedCheckpointInterval;
        this.serializedSessionClearInterval = serializedSessionClearInterval;
        this.customQueryHql = hql;
        this.serializedMaxResultsPerEntity = serializedMaxResultsPerEntity;
        this.serializedPartitionId = partitionIdStr;
        this.serializedLowerBound = serializedLowerBound;
        this.serializedUpperBound = serializedUpperBound;
        this.indexScopeName = indexScopeName;
    }

    public void open(Serializable checkpointInfo) throws Exception {
        FetchingStrategy fetchingStrategy;
        log.openingReader(this.serializedPartitionId, this.entityName);
        int partitionId = SerializationUtil.parseIntegerParameter("partitionId", this.serializedPartitionId);
        boolean isRestarted = checkpointInfo != null;
        this.jobData = this.getOrCreateJobContextData();
        this.emf = this.jobData.getEntityManagerFactory();
        IndexScope indexScope = IndexScope.valueOf(this.indexScopeName);
        CacheMode cacheMode = SerializationUtil.parseCacheModeParameter("cacheMode", this.serializedCacheMode, MassIndexingJobParameters.Defaults.CACHE_MODE);
        int checkpointInterval = SerializationUtil.parseIntegerParameter("checkpointInterval", this.serializedCheckpointInterval);
        Integer sessionClearIntervalRaw = SerializationUtil.parseIntegerParameterOptional("sessionClearInterval", this.serializedSessionClearInterval, null);
        int sessionClearInterval = MassIndexingJobParameters.Defaults.sessionClearInterval(sessionClearIntervalRaw, checkpointInterval);
        int entityFetchSize = SerializationUtil.parseIntegerParameterOptional("entityFetchSize", this.serializedEntityFetchSize, sessionClearInterval);
        Integer maxResults = SerializationUtil.parseIntegerParameterOptional("maxResultsPerEntity", this.serializedMaxResultsPerEntity, null);
        switch (indexScope) {
            case HQL: {
                fetchingStrategy = this.createHqlFetchingStrategy(cacheMode, entityFetchSize, maxResults);
                break;
            }
            case CRITERIA: 
            case FULL_ENTITY: {
                fetchingStrategy = this.createCriteriaFetchingStrategy(cacheMode, entityFetchSize, maxResults);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value from enum: " + IndexScope.class);
            }
        }
        this.chunkState = new ChunkState(this.emf, this.tenantId, fetchingStrategy, sessionClearInterval, checkpointInfo);
        PartitionContextData partitionData = isRestarted ? (PartitionContextData)this.stepContext.getPersistentUserData() : new PartitionContextData(partitionId, this.entityName);
        this.stepContext.setTransientUserData((Object)partitionData);
    }

    public void close() throws Exception {
        log.closingReader(this.serializedPartitionId, this.entityName);
        if (this.chunkState != null) {
            this.chunkState.close();
        }
        PartitionContextData partitionData = (PartitionContextData)this.stepContext.getTransientUserData();
        this.stepContext.setPersistentUserData((Serializable)partitionData);
    }

    public Object readItem() throws Exception {
        log.readingEntity();
        Object entity = this.chunkState.next();
        if (entity == null) {
            log.noMoreResults();
        }
        return entity;
    }

    public Serializable checkpointInfo() throws Exception {
        Serializable checkpointInfo = this.chunkState.end();
        log.checkpointReached(this.entityName, checkpointInfo);
        return checkpointInfo;
    }

    private JobContextData getOrCreateJobContextData() throws ClassNotFoundException, IOException {
        return JobContextUtil.getOrCreateData(this.jobContext, this.emfRegistry, this.entityManagerFactoryNamespace, this.entityManagerFactoryReference, this.serializedEntityTypes, this.serializedCustomQueryCriteria);
    }

    private FetchingStrategy createHqlFetchingStrategy(CacheMode cacheMode, int entityFetchSize, Integer maxResults) {
        String hql = this.customQueryHql;
        return (session, lastCheckpointInfo) -> {
            Query query = session.createQuery(hql);
            if (lastCheckpointInfo != null) {
                query.setFirstResult(lastCheckpointInfo.getProcessedEntityCount());
            }
            if (maxResults != null) {
                int remaining = lastCheckpointInfo != null ? maxResults - lastCheckpointInfo.getProcessedEntityCount() : maxResults;
                query.setMaxResults(remaining);
            }
            return query.setReadOnly(true).setCacheable(false).setLockMode(LockModeType.NONE).setHibernateFlushMode(FlushMode.MANUAL).setCacheMode(cacheMode).setFetchSize(entityFetchSize).scroll(ScrollMode.SCROLL_SENSITIVE);
        };
    }

    private FetchingStrategy createCriteriaFetchingStrategy(CacheMode cacheMode, int entityFetchSize, Integer maxResults) throws Exception {
        Class<?> entityType = this.jobData.getEntityType(this.entityName);
        Object upperBound = SerializationUtil.deserialize(this.serializedUpperBound);
        Object lowerBound = SerializationUtil.deserialize(this.serializedLowerBound);
        Set<Criterion> customQueryCriteria = this.jobData.getCustomQueryCriteria();
        EntityTypeDescriptor typeDescriptor = this.jobData.getEntityTypeDescriptor(entityType);
        IdOrder idOrder = typeDescriptor.getIdOrder();
        return (session, lastCheckpointInfo) -> {
            CriteriaImpl criteria = new CriteriaImpl(entityType.getName(), (SharedSessionContractImplementor)session.unwrap(SessionImplementor.class));
            idOrder.addAscOrder((Criteria)criteria);
            customQueryCriteria.forEach(arg_0 -> EntityReader.lambda$null$1((Criteria)criteria, arg_0));
            if (upperBound != null) {
                criteria.add(idOrder.idLesser(upperBound));
            }
            if (lastCheckpointInfo != null) {
                criteria.add(idOrder.idGreater(lastCheckpointInfo.getLastProcessedEntityId()));
            } else if (lowerBound != null) {
                criteria.add(idOrder.idGreaterOrEqual(lowerBound));
            }
            if (maxResults != null) {
                int remaining = lastCheckpointInfo != null ? maxResults - lastCheckpointInfo.getProcessedEntityCount() : maxResults;
                criteria.setMaxResults(remaining);
            }
            return criteria.setReadOnly(true).setCacheable(false).setLockMode(LockMode.NONE).setFlushMode(FlushMode.MANUAL).setCacheMode(cacheMode).setFetchSize(entityFetchSize).scroll(ScrollMode.FORWARD_ONLY);
        };
    }

    private static /* synthetic */ void lambda$null$1(Criteria criteria, Criterion c) {
        criteria.add(c);
    }

    private static class CheckpointInfo
    implements Serializable {
        private final Serializable lastProcessedEntityId;
        private final int processedEntityCount;

        public CheckpointInfo(Serializable lastProcessedEntityId, int processedEntityCount) {
            this.lastProcessedEntityId = lastProcessedEntityId;
            this.processedEntityCount = processedEntityCount;
        }

        public Serializable getLastProcessedEntityId() {
            return this.lastProcessedEntityId;
        }

        public int getProcessedEntityCount() {
            return this.processedEntityCount;
        }

        public String toString() {
            return "[" + "lastProcessedEntityId = " + this.lastProcessedEntityId + ", processedEntityCount = " + this.processedEntityCount + "]";
        }
    }

    private static class ChunkState
    implements AutoCloseable {
        private final EntityManagerFactory emf;
        private final String tenantId;
        private final FetchingStrategy fetchingStrategy;
        private final int clearInterval;
        private Session session;
        private ScrollableResults scroll;
        private CheckpointInfo lastCheckpointInfo;
        private int processedEntityCount = 0;
        private Serializable lastProcessedEntityId;

        public ChunkState(EntityManagerFactory emf, String tenantId, FetchingStrategy fetchingStrategy, int clearInterval, Serializable checkpointInfo) {
            this.emf = emf;
            this.tenantId = tenantId;
            this.fetchingStrategy = fetchingStrategy;
            this.clearInterval = clearInterval;
            this.lastCheckpointInfo = (CheckpointInfo)checkpointInfo;
        }

        public Object next() {
            if (this.scroll == null) {
                this.start();
            } else if (this.processedEntityCount % this.clearInterval == 0) {
                this.session.clear();
            }
            if (!this.scroll.next()) {
                return null;
            }
            Object entity = this.scroll.get(0);
            this.lastProcessedEntityId = this.session.getIdentifier(entity);
            ++this.processedEntityCount;
            return entity;
        }

        public Serializable end() {
            this.close();
            int processedEntityCountInPartition = this.processedEntityCount;
            if (this.lastCheckpointInfo != null) {
                processedEntityCountInPartition += this.lastCheckpointInfo.getProcessedEntityCount();
            }
            Serializable lastProcessedEntityIdInPartition = this.lastProcessedEntityId;
            if (this.lastCheckpointInfo != null && lastProcessedEntityIdInPartition == null) {
                lastProcessedEntityIdInPartition = this.lastCheckpointInfo.getLastProcessedEntityId();
            }
            this.processedEntityCount = 0;
            this.lastProcessedEntityId = null;
            this.lastCheckpointInfo = new CheckpointInfo(lastProcessedEntityIdInPartition, processedEntityCountInPartition);
            return this.lastCheckpointInfo;
        }

        @Override
        public void close() {
            try (Closer closer = new Closer();){
                if (this.scroll != null) {
                    closer.push(() -> ((ScrollableResults)this.scroll).close());
                    this.scroll = null;
                }
                if (this.session != null) {
                    closer.push(() -> this.session.close());
                    this.session = null;
                }
            }
        }

        private void start() {
            this.session = PersistenceUtil.openSession(this.emf, this.tenantId);
            try {
                this.scroll = this.fetchingStrategy.createScroll(this.session, this.lastCheckpointInfo);
            }
            catch (Throwable t) {
                try {
                    this.session.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
    }

    private static interface FetchingStrategy {
        public ScrollableResults createScroll(Session var1, CheckpointInfo var2);
    }
}

