/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationExecutor;
import org.hibernate.search.backend.impl.StreamingOperationExecutorSelector;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.PartitionContextData;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneDocWriter
extends AbstractItemWriter {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final boolean FORCE_ASYNC = true;
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty(name="entityName")
    private String entityName;
    @Inject
    @BatchProperty(name="partitionId")
    private String partitionIdStr;
    private IndexManagerSelector indexManagerSelector;
    private WriteMode writeMode;

    public void open(Serializable checkpoint) throws Exception {
        log.openingDocWriter(this.partitionIdStr, this.entityName);
        this.writeMode = WriteMode.UPDATE;
        JobContextData jobData = (JobContextData)this.jobContext.getTransientUserData();
        Class<?> entityType = jobData.getEntityType(this.entityName);
        PojoIndexedTypeIdentifier typeIdentifier = new PojoIndexedTypeIdentifier(entityType);
        EntityIndexBinding entityIndexBinding = jobData.getSearchIntegrator().getIndexBinding((IndexedTypeIdentifier)typeIdentifier);
        this.indexManagerSelector = entityIndexBinding.getIndexManagerSelector();
    }

    public void writeItems(List<Object> items) throws Exception {
        for (Object object : items) {
            this.writeItem(object);
        }
        Set indexManagers = this.indexManagerSelector.all();
        for (IndexManager im : indexManagers) {
            im.performStreamOperation((LuceneWork)FlushLuceneWork.INSTANCE, null, false);
        }
        PartitionContextData partitionContextData = (PartitionContextData)this.stepContext.getTransientUserData();
        partitionContextData.documentAdded(items.size());
        this.writeMode = WriteMode.ADD;
    }

    private void writeItem(Object item) {
        LuceneWork work = this.extractWork(item);
        StreamingOperationExecutor executor = (StreamingOperationExecutor)work.acceptIndexWorkVisitor((IndexWorkVisitor)StreamingOperationExecutorSelector.INSTANCE, null);
        executor.performStreamOperation(work, this.indexManagerSelector, null, true);
    }

    private LuceneWork extractWork(Object item) {
        AddLuceneWork addWork = (AddLuceneWork)item;
        switch (this.writeMode) {
            case ADD: {
                return (AddLuceneWork)item;
            }
            case UPDATE: {
                return new UpdateLuceneWork(addWork.getId(), addWork.getIdInString(), addWork.getEntityType(), addWork.getDocument(), addWork.getFieldToAnalyzerMap());
            }
        }
        throw new AssertionFailure("Invalid WriteMode: " + (Object)((Object)this.writeMode));
    }

    private static enum WriteMode {
        ADD,
        UPDATE;

    }
}

