/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.partition.PartitionPlan;
import javax.batch.api.partition.PartitionPlanImpl;
import javax.batch.runtime.context.JobContext;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.MassIndexingJobParameters;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.IndexScope;
import org.hibernate.search.jsr352.massindexing.impl.util.EntityTypeDescriptor;
import org.hibernate.search.jsr352.massindexing.impl.util.PartitionBound;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.jsr352.massindexing.impl.util.SerializationUtil;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PartitionMapper
implements javax.batch.api.partition.PartitionMapper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    @BatchProperty(name="idFetchSize")
    private String serializedIdFetchSize;
    @Inject
    @BatchProperty(name="customQueryHQL")
    private String customQueryHql;
    @Inject
    @BatchProperty(name="maxThreads")
    private String serializedMaxThreads;
    @Inject
    @BatchProperty(name="maxResultsPerEntity")
    private String serializedMaxResultsPerEntity;
    @Inject
    @BatchProperty(name="rowsPerPartition")
    private String serializedRowsPerPartition;
    @Inject
    @BatchProperty(name="checkpointInterval")
    private String serializedCheckpointInterval;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;
    private EntityManagerFactory emf;

    public PartitionMapper() {
    }

    PartitionMapper(String serializedIdFetchSize, String customQueryHql, String serializedMaxThreads, String serializedMaxResultsPerEntity, String serializedRowsPerPartition, String serializedCheckpointInterval, String tenantId) {
        this.serializedIdFetchSize = serializedIdFetchSize;
        this.customQueryHql = customQueryHql;
        this.serializedMaxThreads = serializedMaxThreads;
        this.serializedMaxResultsPerEntity = serializedMaxResultsPerEntity;
        this.serializedRowsPerPartition = serializedRowsPerPartition;
        this.serializedCheckpointInterval = serializedCheckpointInterval;
        this.tenantId = tenantId;
    }

    public PartitionPlan mapPartitions() throws Exception {
        JobContextData jobData = (JobContextData)this.jobContext.getTransientUserData();
        this.emf = jobData.getEntityManagerFactory();
        try (StatelessSession ss = PersistenceUtil.openStatelessSession(this.emf, this.tenantId);){
            Integer maxResults = SerializationUtil.parseIntegerParameterOptional("maxResultsPerEntity", this.serializedMaxResultsPerEntity, null);
            int rowsPerPartition = SerializationUtil.parseIntegerParameterOptional("rowsPerPartition", this.serializedRowsPerPartition, 20000);
            Integer checkpointIntervalRaw = SerializationUtil.parseIntegerParameterOptional("checkpointInterval", this.serializedCheckpointInterval, null);
            int checkpointInterval = MassIndexingJobParameters.Defaults.checkpointInterval(checkpointIntervalRaw, rowsPerPartition);
            int idFetchSize = SerializationUtil.parseIntegerParameterOptional("idFetchSize", this.serializedIdFetchSize, 1000);
            List<EntityTypeDescriptor> entityTypeDescriptors = jobData.getEntityTypeDescriptors();
            List<PartitionBound> partitionBounds = new ArrayList<PartitionBound>();
            switch (PersistenceUtil.getIndexScope(this.customQueryHql, jobData.getCustomQueryCriteria())) {
                case HQL: {
                    Class<?> clazz = entityTypeDescriptors.get(0).getJavaClass();
                    partitionBounds.add(new PartitionBound(clazz, null, null, IndexScope.HQL));
                    break;
                }
                case CRITERIA: {
                    partitionBounds = this.buildPartitionUnitsFrom(ss, entityTypeDescriptors.get(0), jobData.getCustomQueryCriteria(), maxResults, idFetchSize, rowsPerPartition, IndexScope.CRITERIA);
                    break;
                }
                case FULL_ENTITY: {
                    for (EntityTypeDescriptor entityTypeDescriptor : entityTypeDescriptors) {
                        partitionBounds.addAll(this.buildPartitionUnitsFrom(ss, entityTypeDescriptor, Collections.emptySet(), maxResults, idFetchSize, rowsPerPartition, IndexScope.FULL_ENTITY));
                    }
                    break;
                }
            }
            int partitions = partitionBounds.size();
            Properties[] props = new Properties[partitions];
            for (int i = 0; i < partitionBounds.size(); ++i) {
                PartitionBound bound = (PartitionBound)partitionBounds.get(i);
                props[i] = new Properties();
                props[i].setProperty("entityName", bound.getEntityName());
                props[i].setProperty("partitionId", String.valueOf(i));
                props[i].setProperty("lowerBound", SerializationUtil.serialize(bound.getLowerBound()));
                props[i].setProperty("upperBound", SerializationUtil.serialize(bound.getUpperBound()));
                props[i].setProperty("indexScope", bound.getIndexScope().name());
                props[i].setProperty("checkpointInterval", String.valueOf(checkpointInterval));
            }
            log.infof("Partitions: %s", props);
            PartitionPlanImpl partitionPlan = new PartitionPlanImpl();
            partitionPlan.setPartitionProperties(props);
            partitionPlan.setPartitions(partitions);
            Integer threads = SerializationUtil.parseIntegerParameterOptional("maxThreads", this.serializedMaxThreads, null);
            if (threads != null) {
                partitionPlan.setThreads(threads.intValue());
            }
            log.partitionsPlan(partitionPlan.getPartitions(), partitionPlan.getThreads());
            PartitionPlanImpl partitionPlanImpl = partitionPlan;
            return partitionPlanImpl;
        }
    }

    private List<PartitionBound> buildPartitionUnitsFrom(StatelessSession ss, EntityTypeDescriptor entityTypeDescriptor, Set<Criterion> customQueryCriteria, Integer maxResults, int fetchSize, int rowsPerPartition, IndexScope indexScope) {
        Class<?> javaClass = entityTypeDescriptor.getJavaClass();
        ArrayList<PartitionBound> partitionUnits = new ArrayList<PartitionBound>();
        Object lowerID = null;
        Object upperID = null;
        CriteriaImpl criteria = new CriteriaImpl(javaClass.getName(), (SharedSessionContractImplementor)ss);
        entityTypeDescriptor.getIdOrder().addAscOrder((Criteria)criteria);
        if (maxResults != null) {
            criteria.setMaxResults(maxResults.intValue());
        }
        criteria.setProjection((Projection)Projections.id()).setFetchSize(fetchSize).setReadOnly(true).setCacheable(false).setLockMode(LockMode.NONE);
        try (ScrollableResults scroll = criteria.scroll(ScrollMode.SCROLL_SENSITIVE);){
            scroll.next();
            while (scroll.scroll(rowsPerPartition)) {
                lowerID = upperID;
                upperID = scroll.get(0);
                partitionUnits.add(new PartitionBound(javaClass, lowerID, upperID, indexScope));
            }
            lowerID = upperID;
            upperID = null;
            partitionUnits.add(new PartitionBound(javaClass, lowerID, upperID, indexScope));
            ArrayList<PartitionBound> arrayList = partitionUnits;
            return arrayList;
        }
    }
}

