/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.steps.lucene;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.function.BiFunction;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.AbstractStepListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.JobContextData;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.IndexScope;
import org.hibernate.search.jsr352.massindexing.impl.steps.lucene.StepProgress;
import org.hibernate.search.jsr352.massindexing.impl.util.PersistenceUtil;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class StepProgressSetupListener
extends AbstractStepListener {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    @Inject
    private JobContext jobContext;
    @Inject
    private StepContext stepContext;
    @Inject
    @BatchProperty(name="tenantId")
    private String tenantId;
    @Inject
    @BatchProperty(name="customQueryHQL")
    private String customQueryHql;

    public void beforeStep() {
        StepProgress stepProgress = (StepProgress)this.stepContext.getPersistentUserData();
        if (stepProgress == null) {
            BiFunction<Session, Class, Long> rowCountFunction;
            stepProgress = new StepProgress();
            JobContextData jobData = (JobContextData)this.jobContext.getTransientUserData();
            EntityManagerFactory emf = jobData.getEntityManagerFactory();
            Set<Criterion> customQueryCriteria = jobData.getCustomQueryCriteria();
            IndexScope indexScope = PersistenceUtil.getIndexScope(this.customQueryHql, customQueryCriteria);
            switch (indexScope) {
                case HQL: {
                    rowCountFunction = (session, clazz) -> null;
                    break;
                }
                case CRITERIA: 
                case FULL_ENTITY: {
                    rowCountFunction = (session, clazz) -> StepProgressSetupListener.rowCountCriteria(session, clazz, customQueryCriteria);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown value from enum: " + IndexScope.class);
                }
            }
            try (Session session2 = PersistenceUtil.openSession(emf, this.tenantId);){
                for (Class<?> entityType : jobData.getEntityTypes()) {
                    Long rowCount = rowCountFunction.apply(session2, entityType);
                    log.rowsToIndex(entityType.getName(), rowCount);
                    stepProgress.setRowsToIndex(entityType.getName(), rowCount);
                }
            }
        }
        this.stepContext.setTransientUserData((Object)stepProgress);
    }

    public void afterStep() {
        StepProgress stepProgress = (StepProgress)this.stepContext.getTransientUserData();
        this.stepContext.setPersistentUserData((Serializable)stepProgress);
    }

    private static Long rowCountCriteria(Session session, Class<?> entityType, Set<Criterion> customQueryCriteria) {
        CriteriaImpl criteria = new CriteriaImpl(entityType.getName(), (SharedSessionContractImplementor)session.unwrap(SessionImplementor.class));
        customQueryCriteria.forEach(arg_0 -> StepProgressSetupListener.lambda$rowCountCriteria$2((Criteria)criteria, arg_0));
        return (Long)criteria.setProjection(Projections.rowCount()).setCacheable(false).uniqueResult();
    }

    private static /* synthetic */ void lambda$rowCountCriteria$2(Criteria criteria, Criterion c) {
        criteria.add(c);
    }
}

