/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jsr352.massindexing.impl.util;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.hcore.util.impl.ContextHelper;
import org.hibernate.search.jsr352.context.jpa.spi.EntityManagerFactoryRegistry;
import org.hibernate.search.jsr352.logging.impl.Log;
import org.hibernate.search.jsr352.massindexing.impl.util.JobContextUtil;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ValidationUtil {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ValidationUtil() {
    }

    public static void validateCheckpointInterval(int checkpointInterval, int rowsPerPartition) {
        if (checkpointInterval > rowsPerPartition) {
            throw log.illegalCheckpointInterval(checkpointInterval, rowsPerPartition);
        }
    }

    public static void validateSessionClearInterval(int sessionClearInterval, int checkpointInterval) {
        if (sessionClearInterval > checkpointInterval) {
            throw log.illegalSessionClearInterval(sessionClearInterval, checkpointInterval);
        }
    }

    public static void validatePositive(String parameterName, int parameterValue) {
        if (parameterValue <= 0) {
            throw log.negativeValueOrZero(parameterName, parameterValue);
        }
    }

    public static void validateEntityTypes(EntityManagerFactoryRegistry emfRegistry, String entityManagerFactoryScope, String entityManagerFactoryReference, String serializedEntityTypes) {
        EntityManagerFactory emf = JobContextUtil.getEntityManagerFactory(emfRegistry, entityManagerFactoryScope, entityManagerFactoryReference);
        ExtendedSearchIntegrator searchIntegrator = ContextHelper.getSearchIntegratorBySF((SessionFactory)((SessionFactory)emf.unwrap(SessionFactory.class)));
        HashSet<String> failingTypes = new HashSet<String>();
        IndexedTypeSet typeIds = searchIntegrator.getIndexedTypeIdentifiers();
        HashSet<String> indexedTypes = new HashSet<String>();
        for (IndexedTypeIdentifier typeId : typeIds) {
            indexedTypes.add(typeId.getName());
        }
        for (String type : serializedEntityTypes.split(",")) {
            if (indexedTypes.contains(type)) continue;
            failingTypes.add(type);
        }
        if (failingTypes.size() > 0) {
            throw log.failingEntityTypes(String.join((CharSequence)", ", failingTypes));
        }
    }
}

