/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.junit.Assert;

public class SQLStatementInterceptor {
    private final LinkedList<String> sqlQueries = new LinkedList();

    public SQLStatementInterceptor(SessionFactoryBuilder sessionFactoryBuilder) {
        sessionFactoryBuilder.applyStatementInspector((StatementInspector & Serializable)sql -> {
            this.sqlQueries.add(sql);
            return sql;
        });
    }

    public SQLStatementInterceptor(Map settings) {
        settings.put("hibernate.session_factory.statement_inspector", (StatementInspector & Serializable)sql -> {
            this.sqlQueries.add(sql);
            return sql;
        });
    }

    public LinkedList<String> getSqlQueries() {
        return this.sqlQueries;
    }

    public void clear() {
        this.sqlQueries.clear();
    }

    public void assertExecuted(String expected) {
        Assert.assertTrue((boolean)this.sqlQueries.contains(expected));
    }

    public void assertExecutedCount(int expected) {
        Assert.assertEquals((long)expected, (long)this.sqlQueries.size());
    }
}

