/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.dialect.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl.SerializableRowKey;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public final class SerializableMapAssociationSnapshot
implements AssociationSnapshot {
    private final Map<SerializableRowKey, Map<String, Object>> associationMap;

    public SerializableMapAssociationSnapshot(Map<SerializableRowKey, Map<String, Object>> associationMap) {
        this.associationMap = associationMap;
    }

    public Tuple get(RowKey column) {
        Map<String, Object> rawResult = this.associationMap.get(new SerializableRowKey(column));
        return rawResult != null ? new Tuple((TupleSnapshot)new MapTupleSnapshot(rawResult), Tuple.SnapshotType.UPDATE) : null;
    }

    public boolean containsKey(RowKey column) {
        return this.associationMap.containsKey(new SerializableRowKey(column));
    }

    public int size() {
        return this.associationMap.size();
    }

    public Set<RowKey> getRowKeys() {
        HashSet<RowKey> rowKeys = new HashSet<RowKey>(this.associationMap.size());
        for (SerializableRowKey key : this.associationMap.keySet()) {
            rowKeys.add(new RowKey(key.getColumnNames(), key.getColumnValues()));
        }
        return rowKeys;
    }

    public Map<SerializableRowKey, Map<String, Object>> getUnderlyingMap() {
        return this.associationMap;
    }
}

