/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.associations.onetoone;

import java.io.Serializable;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.associations.onetoone.Cavalier;
import org.hibernate.ogm.test.associations.onetoone.Horse;
import org.hibernate.ogm.test.associations.onetoone.Husband;
import org.hibernate.ogm.test.associations.onetoone.Vehicule;
import org.hibernate.ogm.test.associations.onetoone.Wheel;
import org.hibernate.ogm.test.associations.onetoone.Wife;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;

public class OneToOneTest
extends OgmTestCase {
    public void testUnidirectionalManyToOne() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Horse horse = new Horse();
        horse.setName("Palefrenier");
        Cavalier cavalier = new Cavalier();
        cavalier.setName("Caroline");
        cavalier.setHorse(horse);
        session.persist((Object)horse);
        session.persist((Object)cavalier);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        cavalier = (Cavalier)session.get(Cavalier.class, (Serializable)((Object)cavalier.getId()));
        horse = cavalier.getHorse();
        session.delete((Object)cavalier);
        session.delete((Object)horse);
        transaction.commit();
        session.close();
        this.checkCleanCache();
    }

    public void testUnidirectionalOneToOne() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Vehicule vehicule = new Vehicule();
        vehicule.setBrand("Mercedes");
        Wheel wheel = new Wheel();
        wheel.setVehicule(vehicule);
        session.persist((Object)vehicule);
        session.persist((Object)wheel);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        wheel = (Wheel)session.get(Wheel.class, (Serializable)((Object)wheel.getId()));
        vehicule = wheel.getVehicule();
        session.delete((Object)wheel);
        session.delete((Object)vehicule);
        transaction.commit();
        session.close();
    }

    public void testBidirectionalManyToOne() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Husband husband = new Husband();
        husband.setName("Alex");
        Wife wife = new Wife();
        wife.setName("Bea");
        husband.setWife(wife);
        wife.setHusband(husband);
        session.persist((Object)husband);
        session.persist((Object)wife);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        husband = (Husband)session.get(Husband.class, (Serializable)((Object)husband.getId()));
        OneToOneTest.assertNotNull((Object)husband);
        OneToOneTest.assertNotNull((Object)husband.getWife());
        session.clear();
        wife = (Wife)session.get(Wife.class, (Serializable)((Object)wife.getId()));
        OneToOneTest.assertNotNull((Object)wife);
        husband = wife.getHusband();
        OneToOneTest.assertNotNull((Object)husband);
        Wife bea2 = new Wife();
        session.persist((Object)bea2);
        bea2.setName("Still Bea");
        husband.setWife(bea2);
        wife.setHusband(null);
        bea2.setHusband(husband);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        husband = (Husband)session.get(Husband.class, (Serializable)((Object)husband.getId()));
        OneToOneTest.assertNotNull((Object)husband);
        OneToOneTest.assertNotNull((Object)husband.getWife());
        session.clear();
        wife = (Wife)session.get(Wife.class, (Serializable)((Object)wife.getId()));
        OneToOneTest.assertNotNull((Object)wife);
        OneToOneTest.assertNull((Object)wife.getHusband());
        session.delete((Object)wife);
        bea2 = (Wife)session.get(Wife.class, (Serializable)((Object)bea2.getId()));
        OneToOneTest.assertNotNull((Object)bea2);
        husband = bea2.getHusband();
        OneToOneTest.assertNotNull((Object)husband);
        bea2.setHusband(null);
        husband.setWife(null);
        session.delete((Object)husband);
        session.delete((Object)wife);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Horse.class, Cavalier.class, Vehicule.class, Wheel.class, Husband.class, Wife.class};
    }
}

