/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.hibernatecore;

import javax.naming.Reference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryObjectFactory;
import org.hibernate.ogm.test.hibernatecore.Contact;
import org.hibernate.ogm.test.utils.BaseOGMTest;
import org.hibernate.ogm.test.utils.PackagingRule;
import org.hibernate.ogm.test.utils.TestHelper;
import org.junit.Rule;
import org.junit.Test;

public class HibernateCoreAPIWrappingTest
extends BaseOGMTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/jpajtastandalone.xml", Contact.class);

    @Test
    public void testWrappedFromEntityManagerAPI() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpajtastandalone", TestHelper.getEnvironmentProperties());
        Assertions.assertThat((boolean)HibernateEntityManagerFactory.class.isAssignableFrom(emf.getClass())).isTrue();
        SessionFactory factory = ((HibernateEntityManagerFactory)emf).getSessionFactory();
        Assertions.assertThat(factory.getClass()).isEqualTo(OgmSessionFactory.class);
        Session s = factory.openSession();
        Assertions.assertThat(s.getClass()).isEqualTo(OgmSession.class);
        Assertions.assertThat(s.getSessionFactory().getClass()).isEqualTo(OgmSessionFactory.class);
        s.close();
        EntityManager em = emf.createEntityManager();
        Assertions.assertThat(((Session)em.unwrap(Session.class)).getClass()).isEqualTo(OgmSession.class);
        Assertions.assertThat(em.getDelegate().getClass()).isEqualTo(OgmSession.class);
        em.close();
        emf.close();
    }

    @Test
    public void testJNDIReference() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpajtastandalone", TestHelper.getEnvironmentProperties());
        SessionFactory factory = ((HibernateEntityManagerFactory)emf).getSessionFactory();
        Reference reference = factory.getReference();
        Assertions.assertThat((String)reference.getClassName()).isEqualTo((Object)OgmSessionFactory.class.getName());
        Assertions.assertThat((String)reference.getFactoryClassName()).isEqualTo((Object)OgmSessionFactoryObjectFactory.class.getName());
        Assertions.assertThat((Object)reference.get(0)).isNotNull();
        Assertions.assertThat((String)reference.getFactoryClassLocation()).isNull();
        OgmSessionFactoryObjectFactory objFactory = new OgmSessionFactoryObjectFactory();
        SessionFactory factoryFromRegistry = (SessionFactory)objFactory.getObjectInstance((Object)reference, null, null, null);
        Assertions.assertThat(factoryFromRegistry.getClass()).isEqualTo(OgmSessionFactory.class);
        Assertions.assertThat((Object)factoryFromRegistry.getReference()).isEqualTo((Object)factory.getReference());
        emf.close();
    }
}

