/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.hsearch;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.ogm.test.hsearch.Insurance;
import org.hibernate.ogm.test.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.DatabaseRetrievalMethod;
import org.hibernate.search.query.ObjectLookupMethod;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.junit.Test;

public class HibernateSearchAtopOgmTest
extends JpaTestCase {
    @Test
    public void testHibernateSearchJPAAPIUsage() throws Exception {
        this.getTransactionManager().begin();
        FullTextEntityManager ftem = Search.getFullTextEntityManager((EntityManager)this.getFactory().createEntityManager());
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        ftem.persist((Object)insurance);
        this.getTransactionManager().commit();
        ftem.clear();
        this.getTransactionManager().begin();
        QueryBuilder b = ftem.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        FullTextQuery ftQuery = ftem.createFullTextQuery(lq, new Class[]{Insurance.class});
        ftQuery.initializeObjectsWith(ObjectLookupMethod.SKIP, DatabaseRetrievalMethod.FIND_BY_ID);
        List resultList = ftQuery.getResultList();
        Assertions.assertThat((boolean)this.getFactory().getPersistenceUnitUtil().isLoaded(resultList.get(0))).isTrue();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Insurance e : resultList) {
            ftem.remove((Object)e);
        }
        this.getTransactionManager().commit();
        ftem.close();
    }

    @Test
    public void testHibernateSearchNativeAPIUsage() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityManager = this.getFactory().createEntityManager();
        FullTextSession ftSession = org.hibernate.search.Search.getFullTextSession((Session)((Session)entityManager.unwrap(Session.class)));
        Insurance insurance = new Insurance();
        insurance.setName("Macif");
        ftSession.persist((Object)insurance);
        this.getTransactionManager().commit();
        ftSession.clear();
        this.getTransactionManager().begin();
        QueryBuilder b = ftSession.getSearchFactory().buildQueryBuilder().forEntity(Insurance.class).get();
        Query lq = b.keyword().onField("name").matching((Object)"Macif").createQuery();
        org.hibernate.search.FullTextQuery ftQuery = ftSession.createFullTextQuery(lq, new Class[]{Insurance.class});
        ftQuery.initializeObjectsWith(ObjectLookupMethod.SKIP, DatabaseRetrievalMethod.FIND_BY_ID);
        List resultList = ftQuery.list();
        Assertions.assertThat((boolean)this.getFactory().getPersistenceUnitUtil().isLoaded(resultList.get(0))).isTrue();
        Assertions.assertThat((List)resultList).hasSize(1);
        for (Insurance e : resultList) {
            ftSession.delete((Object)e);
        }
        this.getTransactionManager().commit();
        entityManager.close();
    }

    @Override
    protected void refineInfo(GetterPersistenceUnitInfo info) {
        super.refineInfo(info);
        info.getProperties().setProperty("hibernate.search.default.directory_provider", "ram");
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Insurance.class};
    }
}

