/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.id.DistributedRevisionControl;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Test;

public class AutoIdGeneratorTest
extends JpaTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoIdentifierGenerator() throws Exception {
        DistributedRevisionControl git = new DistributedRevisionControl();
        DistributedRevisionControl bzr = new DistributedRevisionControl();
        this.getTransactionManager().begin();
        EntityManager em = this.getFactory().createEntityManager();
        boolean operationSuccessfull = false;
        try {
            git.setName("Git");
            em.persist((Object)git);
            bzr.setName("Bazaar");
            em.persist((Object)bzr);
            operationSuccessfull = true;
        }
        finally {
            this.commitOrRollback(operationSuccessfull);
        }
        em.clear();
        this.getTransactionManager().begin();
        operationSuccessfull = false;
        try {
            DistributedRevisionControl dvcs = (DistributedRevisionControl)em.find(DistributedRevisionControl.class, (Object)git.getId());
            Assertions.assertThat((Object)dvcs).isNotNull();
            Assertions.assertThat((Long)dvcs.getId()).isEqualTo(1L);
            em.remove((Object)dvcs);
            dvcs = (DistributedRevisionControl)em.find(DistributedRevisionControl.class, (Object)bzr.getId());
            Assertions.assertThat((Object)dvcs).isNotNull();
            Assertions.assertThat((Long)dvcs.getId()).isEqualTo(2L);
            operationSuccessfull = true;
        }
        finally {
            this.commitOrRollback(operationSuccessfull);
        }
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{DistributedRevisionControl.class};
    }
}

