/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.id.Label;
import org.hibernate.ogm.test.id.News;
import org.hibernate.ogm.test.id.NewsID;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Test;

public class CompositeIdTest
extends JpaTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeEmbeddedId() throws Exception {
        String titleOGM = "How to use Hibernate OGM ?";
        String titleAboutJUG = "What is a JUG ?";
        String titleCountJUG = "There are more than 20 JUGs in France";
        String author = "Guillaume";
        String contentOGM = "Simple, just like ORM but with a NoSQL database";
        String contentAboutJUG = "JUG means Java User Group";
        String contentCountJUG = "Great! Congratulations folks";
        Label questionLabel = new Label("question");
        Label jugLabel = new Label("jug");
        Label hibernateLabel = new Label("hibernate");
        Label ogmLabel = new Label("OGM");
        Label statJugLabel = new Label("statJUG");
        NewsID newsOgmID = new NewsID("How to use Hibernate OGM ?", "Guillaume");
        NewsID newsAboutJugID = new NewsID("What is a JUG ?", "Guillaume");
        NewsID newsCountJugID = new NewsID("There are more than 20 JUGs in France", "Guillaume");
        ArrayList<Label> newsOgmLabels = new ArrayList<Label>();
        newsOgmLabels.add(ogmLabel);
        newsOgmLabels.add(hibernateLabel);
        ArrayList<Label> newsAboutJugLabels = new ArrayList<Label>();
        newsAboutJugLabels.add(jugLabel);
        newsAboutJugLabels.add(questionLabel);
        ArrayList<Label> newsCountJugLabels = new ArrayList<Label>();
        newsCountJugLabels.add(statJugLabel);
        News newsAboutJUG = new News(newsAboutJugID, "JUG means Java User Group", newsAboutJugLabels);
        News newsOGM = new News(newsOgmID, "Simple, just like ORM but with a NoSQL database", newsOgmLabels);
        News newsCountJUG = new News(newsCountJugID, "Great! Congratulations folks", newsCountJugLabels);
        boolean operationSuccessful = false;
        this.getTransactionManager().begin();
        EntityManager em = this.getFactory().createEntityManager();
        try {
            em.persist((Object)newsOGM);
            em.persist((Object)newsAboutJUG);
            em.persist((Object)newsCountJUG);
            operationSuccessful = true;
        }
        finally {
            this.commitOrRollback(operationSuccessful);
        }
        em.clear();
        this.getTransactionManager().begin();
        operationSuccessful = false;
        try {
            News news = (News)em.find(News.class, (Object)newsOgmID);
            Assertions.assertThat((Object)news).isNotNull();
            Assertions.assertThat((String)news.getContent()).isEqualTo((Object)"Simple, just like ORM but with a NoSQL database");
            Assertions.assertThat((String)news.getNewsId().getAuthor()).isEqualTo((Object)"Guillaume");
            Assertions.assertThat((String)news.getNewsId().getTitle()).isEqualTo((Object)"How to use Hibernate OGM ?");
            Assertions.assertThat((int)news.getLabels().size()).isEqualTo(newsOgmLabels.size());
            em.remove((Object)news);
            Assertions.assertThat((Object)em.find(News.class, (Object)newsOgmID)).isNull();
            em.clear();
            news = (News)em.find(News.class, (Object)newsAboutJugID);
            Assertions.assertThat((Object)news).isNotNull();
            Assertions.assertThat((String)news.getContent()).isEqualTo((Object)"JUG means Java User Group");
            Assertions.assertThat((String)news.getNewsId().getAuthor()).isEqualTo((Object)"Guillaume");
            Assertions.assertThat((String)news.getNewsId().getTitle()).isEqualTo((Object)"What is a JUG ?");
            Assertions.assertThat((int)news.getLabels().size()).isEqualTo(newsAboutJugLabels.size());
            em.remove((Object)news);
            Assertions.assertThat((Object)em.find(News.class, (Object)newsAboutJugID)).isNull();
            em.clear();
            news = (News)em.find(News.class, (Object)newsCountJugID);
            Assertions.assertThat((Object)news).isNotNull();
            Assertions.assertThat((String)news.getContent()).isEqualTo((Object)"Great! Congratulations folks");
            Assertions.assertThat((String)news.getNewsId().getAuthor()).isEqualTo((Object)"Guillaume");
            Assertions.assertThat((String)news.getNewsId().getTitle()).isEqualTo((Object)"There are more than 20 JUGs in France");
            Assertions.assertThat((int)news.getLabels().size()).isEqualTo(newsCountJugLabels.size());
            em.remove((Object)news);
            Assertions.assertThat((Object)em.find(News.class, (Object)newsCountJugID)).isNull();
        }
        finally {
            this.commitOrRollback(operationSuccessful);
        }
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{News.class, NewsID.class, Label.class};
    }
}

