/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import org.hibernate.ogm.test.id.Label;
import org.hibernate.ogm.test.id.NewsID;

@Entity
public class News {
    @EmbeddedId
    private NewsID newsId;
    private String content;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="news_topic_fk", referencedColumnName="newsid.title", nullable=false), @JoinColumn(name="news_author_fk", referencedColumnName="newsid.author", nullable=false)})
    private List<Label> labels;

    public News() {
    }

    public News(NewsID newsId, String content, List<Label> labels) {
        this.newsId = newsId;
        this.content = content;
        this.labels = labels;
    }

    public NewsID getNewsId() {
        return this.newsId;
    }

    public void setNewsId(NewsID newsId) {
        this.newsId = newsId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        News news = (News)o;
        if (this.content != null ? !this.content.equals(news.content) : news.content != null) {
            return false;
        }
        if (this.labels != null ? !((Object)this.labels).equals(news.labels) : news.labels != null) {
            return false;
        }
        return !(this.newsId != null ? !this.newsId.equals(news.newsId) : news.newsId != null);
    }

    public int hashCode() {
        int result = this.newsId != null ? this.newsId.hashCode() : 0;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.labels != null ? ((Object)this.labels).hashCode() : 0);
        return result;
    }
}

