/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.jpa;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.jpa.impl.OgmEntityManager;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.test.jpa.Poem;
import org.hibernate.ogm.test.utils.PackagingRule;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JPAAPIWrappingTest
extends JpaTestCase {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/jpajtastandalone.xml", Poem.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWrappedStandalone() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpajtastandalone", TestHelper.getEnvironmentProperties());
        Assertions.assertThat(emf.getClass()).isEqualTo(OgmEntityManagerFactory.class);
        EntityManager em = emf.createEntityManager();
        Assertions.assertThat(em.getClass()).isEqualTo(OgmEntityManager.class);
        em.close();
        em = emf.createEntityManager(new HashMap());
        Assertions.assertThat(em.getClass()).isEqualTo(OgmEntityManager.class);
        em.close();
        emf.close();
    }

    @Test
    public void testUndefinedPU() throws Exception {
        this.thrown.expect(PersistenceException.class);
        Persistence.createEntityManagerFactory((String)"does-not-exist-PU");
    }

    @Test
    public void testWrapInContainer() throws Exception {
        Assertions.assertThat(this.getFactory().getClass()).isEqualTo(OgmEntityManagerFactory.class);
        EntityManager entityManager = this.getFactory().createEntityManager();
        Assertions.assertThat(entityManager.getClass()).isEqualTo(OgmEntityManager.class);
        entityManager.close();
        entityManager = this.getFactory().createEntityManager(new HashMap());
        Assertions.assertThat(entityManager.getClass()).isEqualTo(OgmEntityManager.class);
        entityManager.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Poem.class};
    }
}

