/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.jpa.Poem;
import org.hibernate.ogm.test.utils.PackagingRule;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Rule;
import org.junit.Test;

public class JPAStandaloneTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/jpajtastandalone.xml", Poem.class);

    @Test
    public void testJTAStandalone() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpajtastandalone", TestHelper.getEnvironmentProperties());
        TransactionManager transactionManager = JpaTestCase.extractJBossTransactionManager(emf);
        transactionManager.begin();
        EntityManager em = emf.createEntityManager();
        Poem poem = new Poem();
        poem.setName("L'albatros");
        em.persist((Object)poem);
        transactionManager.commit();
        em.clear();
        transactionManager.begin();
        poem = (Poem)em.find(Poem.class, (Object)poem.getId());
        Assertions.assertThat((Object)poem).isNotNull();
        Assertions.assertThat((String)poem.getName()).isEqualTo((Object)"L'albatros");
        em.remove((Object)poem);
        transactionManager.commit();
        em.close();
        TestHelper.dropSchemaAndDatabase(emf);
        emf.close();
    }
}

