/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.mongodb.datastore;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.fest.assertions.Assertions;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.test.utils.TestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DatastoreInitializationTest {
    @Rule
    public ExpectedException error = ExpectedException.none();

    @Test
    public void testAuthentication() throws Exception {
        Map<String, String> cfg = TestHelper.getEnvironmentProperties();
        cfg.put("hibernate.ogm.mongodb.database", "test");
        cfg.put("hibernate.ogm.mongodb.username", "notauser");
        cfg.put("hibernate.ogm.mongodb.password", "test");
        MongoDBDatastoreProvider provider = new MongoDBDatastoreProvider();
        provider.configure(cfg);
        this.error.expect(HibernateException.class);
        this.error.expectMessage("OGM001213");
        provider.start();
    }

    @Test
    public void testConnectionErrorWrappedInHibernateException() throws Exception {
        Properties properties = new Properties();
        properties.load(DatastoreInitializationTest.class.getClassLoader().getResourceAsStream("hibernate.properties"));
        Map<String, String> cfg = TestHelper.getEnvironmentProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            cfg.put((String)entry.getKey(), (String)entry.getValue());
        }
        cfg.put("hibernate.ogm.mongodb.host", "203.0.113.1");
        MongoDBDatastoreProvider provider = new MongoDBDatastoreProvider();
        provider.configure(cfg);
        this.error.expect(HibernateException.class);
        this.error.expectMessage("OGM001214");
        provider.start();
    }

    @Test
    public void testConnectionTimeout() {
        String host = "203.0.113.1";
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("hibernate.ogm.mongodb.connection_timeout", "30");
        cfg.put("hibernate.ogm.mongodb.host", host);
        cfg.put("hibernate.ogm.mongodb.database", "ogm_test_database");
        MongoDBDatastoreProvider provider = new MongoDBDatastoreProvider();
        long estimateSpentTime = 3000000000L;
        provider.configure(cfg);
        Exception exception = null;
        long start = System.nanoTime();
        try {
            provider.start();
        }
        catch (Exception e) {
            exception = e;
            Assertions.assertThat((long)(System.nanoTime() - start)).isLessThanOrEqualTo(3000000000L);
        }
        if (exception == null) {
            Assert.fail((String)("The expected exception has not been raised, a MongoDB instance runs on " + host));
        }
    }
}

