/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.mongodb.loading;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.impl.DatastoreServices;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.mongodb.MongoDBAssociationSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.test.mongodb.loading.Module;
import org.hibernate.ogm.test.mongodb.loading.Project;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.Test;

public class LoadSelectedColumnsCollectionTest
extends OgmTestCase {
    @Test
    public void testLoadSelectedColumns() {
        String collectionName = "Drink";
        MongoDBDatastoreProvider provider = (MongoDBDatastoreProvider)this.getService(DatastoreProvider.class);
        DB database = provider.getDatabase();
        DBCollection collection = database.getCollection("Drink");
        BasicDBObject water = new BasicDBObject();
        water.put("_id", (Object)"1234");
        water.put("name", (Object)"Water");
        water.put("volume", (Object)"1L");
        collection.insert(new DBObject[]{water});
        ArrayList<String> selectedColumns = new ArrayList<String>();
        selectedColumns.add("name");
        Tuple tuple = this.getTuple("Drink", "1234", selectedColumns);
        LoadSelectedColumnsCollectionTest.assertNotNull((Object)tuple);
        Set retrievedColumn = tuple.getColumnNames();
        LoadSelectedColumnsCollectionTest.assertEquals((int)selectedColumns.size(), (int)(retrievedColumn.size() - 1));
        LoadSelectedColumnsCollectionTest.assertTrue((boolean)retrievedColumn.containsAll(selectedColumns));
        collection.remove((DBObject)water);
    }

    @Test
    public void testLoadSelectedAssociationColumns() {
        Session session = this.openSession();
        Transaction transaction = session.getTransaction();
        transaction.begin();
        Module mongodb = new Module();
        mongodb.setName("MongoDB");
        session.persist((Object)mongodb);
        Module infinispan = new Module();
        infinispan.setName("Infinispan");
        session.persist((Object)infinispan);
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(mongodb);
        modules.add(infinispan);
        Project hibernateOGM = new Project();
        hibernateOGM.setId("projectID");
        hibernateOGM.setName("HibernateOGM");
        hibernateOGM.setModules(modules);
        session.persist((Object)hibernateOGM);
        transaction.commit();
        this.addExtraColumn();
        GridDialect gridDialect = this.getGridDialect();
        AssociationKey associationKey = new AssociationKey("Project_Module", new String[]{"Project_id"}, new Object[]{"projectID"});
        associationKey.setAssociationKind(AssociationKind.ASSOCIATION);
        associationKey.setCollectionRole("modules");
        associationKey.setOwnerEntityKey(new EntityKey("Project", new String[]{"id"}, (Object[])new String[]{"projectID"}));
        associationKey.setRowKeyColumnNames(new String[]{"Project_id", "module_id"});
        AssociationContext associationContext = new AssociationContext(Arrays.asList(associationKey.getRowKeyColumnNames()));
        Association association = gridDialect.getAssociation(associationKey, associationContext);
        MongoDBAssociationSnapshot associationSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
        DBObject assocObject = associationSnapshot.getDBObject();
        this.checkLoading(assocObject);
        session.delete((Object)mongodb);
        session.delete((Object)infinispan);
        session.delete((Object)hibernateOGM);
        session.close();
    }

    public Tuple getTuple(String collectionName, String id, List<String> selectedColumns) {
        EntityKey key = new EntityKey(collectionName, new String[]{"_id"}, new Object[]{id});
        TupleContext tupleContext = new TupleContext(selectedColumns);
        return this.getGridDialect().getTuple(key, tupleContext);
    }

    protected Service getService(Class<? extends Service> serviceImpl) {
        SessionFactoryImplementor factory = super.sfi();
        ServiceRegistryImplementor serviceRegistry = factory.getServiceRegistry();
        return serviceRegistry.getService(serviceImpl);
    }

    protected GridDialect getGridDialect() {
        return ((DatastoreServices)this.getService(DatastoreServices.class)).getGridDialect();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.ogm.mongodb.associations.store", AssociationStorage.COLLECTION.toString().toLowerCase());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Project.class, Module.class};
    }

    protected void addExtraColumn() {
        MongoDBDatastoreProvider provider = (MongoDBDatastoreProvider)this.getService(DatastoreProvider.class);
        DB database = provider.getDatabase();
        DBCollection collection = database.getCollection("associations_Project_Module");
        BasicDBObject query = new BasicDBObject(1);
        query.put("_id", (Object)new BasicDBObject("Project_id", (Object)"projectID"));
        BasicDBObject updater = new BasicDBObject(1);
        updater.put("$push", (Object)new BasicDBObject("extraColumn", (Object)1));
        collection.update((DBObject)query, (DBObject)updater);
    }

    protected void checkLoading(DBObject associationObject) {
        Set retrievedColumns = associationObject.keySet();
        ((CollectionAssert)Assertions.assertThat((Collection)retrievedColumns).hasSize(2)).containsOnly(new Object[]{"_id", "rows"});
    }
}

