/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.mongodb.loading;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.hibernate.cfg.Configuration;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.test.mongodb.loading.LoadSelectedColumnsCollectionTest;

public class LoadSelectedColumnsInEntityTest
extends LoadSelectedColumnsCollectionTest {
    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.ogm.mongodb.associations.store", AssociationStorage.IN_ENTITY.toString().toLowerCase());
    }

    @Override
    protected void addExtraColumn() {
        MongoDBDatastoreProvider provider = (MongoDBDatastoreProvider)super.getService(DatastoreProvider.class);
        DB database = provider.getDatabase();
        DBCollection collection = database.getCollection("Project");
        BasicDBObject query = new BasicDBObject(1);
        query.put("_id", (Object)"projectID");
        BasicDBObject updater = new BasicDBObject(1);
        updater.put("$push", (Object)new BasicDBObject("extraColumn", (Object)1));
        collection.update((DBObject)query, (DBObject)updater);
    }

    @Override
    protected void checkLoading(DBObject associationObject) {
        Set retrievedColumns = associationObject.keySet();
        ((CollectionAssert)Assertions.assertThat((Collection)retrievedColumns).hasSize(2)).containsOnly(new Object[]{"_id", "modules"});
    }
}

