/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.simpleentity;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import junit.framework.TestCase;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.cfg.OgmConfiguration;
import org.hibernate.ogm.test.utils.GridDialectType;
import org.hibernate.ogm.test.utils.SkipByGridDialect;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.testing.FailureExpected;
import org.junit.After;
import org.junit.Before;

public abstract class OgmTestCase
extends TestCase {
    private static final Log log;
    protected SessionFactory sessions;
    private Session session;
    protected static Configuration cfg;
    private static Class<?> lastTestClass;

    @Before
    public void setUp() throws Exception {
        if (cfg == null || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildConfiguration();
            lastTestClass = ((Object)((Object)this)).getClass();
        }
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    protected static void setCfg(Configuration cfg) {
        OgmTestCase.cfg = cfg;
    }

    protected static Configuration getCfg() {
        return cfg;
    }

    protected void configure(Configuration cfg) {
    }

    @After
    public void tearDown() throws Exception {
        this.handleUnclosedResources();
        this.closeResources();
    }

    protected abstract Class<?>[] getAnnotatedClasses();

    protected boolean recreateSchema() {
        return true;
    }

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    private void reportSkip(Skip skip) {
        this.reportSkip(skip.reason, skip.testDescription);
    }

    protected void reportSkip(String reason, String testDescription) {
        StringBuilder builder = new StringBuilder();
        builder.append("*** skipping test [");
        builder.append(this.fullTestName());
        builder.append("] - ");
        builder.append(testDescription);
        builder.append(" : ");
        builder.append(reason);
        log.warn((Object)builder.toString());
    }

    protected Skip buildSkip(GridDialectType dialect, String comment) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("skipping database-specific test [");
        buffer.append(this.fullTestName());
        buffer.append("] for dialect [");
        buffer.append(dialect.name());
        buffer.append(']');
        if (StringHelper.isNotEmpty((String)comment)) {
            buffer.append("; ").append(comment);
        }
        return new Skip(buffer.toString(), null);
    }

    protected <T extends Annotation> T locateAnnotation(Class<T> annotationClass, Method runMethod) {
        T annotation = runMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ((Object)((Object)this)).getClass().getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = runMethod.getDeclaringClass().getAnnotation(annotationClass);
        }
        return annotation;
    }

    protected final Skip determineSkipByGridDialect(Method runMethod) throws Exception {
        SkipByGridDialect skipForDialectAnn = this.locateAnnotation(SkipByGridDialect.class, runMethod);
        if (skipForDialectAnn != null) {
            for (GridDialectType gridDialectType : skipForDialectAnn.value()) {
                if (!gridDialectType.equals((Object)TestHelper.getCurrentDialectType())) continue;
                return this.buildSkip(gridDialectType, skipForDialectAnn.comment());
            }
        }
        return null;
    }

    protected void runTest() throws Throwable {
        Method runMethod = this.findTestMethod();
        FailureExpected failureExpected = this.locateAnnotation(FailureExpected.class, runMethod);
        try {
            super.runTest();
            if (failureExpected != null) {
                throw new FailureExpectedTestPassedException();
            }
        }
        catch (FailureExpectedTestPassedException t) {
            this.closeResources();
            throw t;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof IllegalAccessException) {
                t.fillInStackTrace();
            }
            this.closeResources();
            if (failureExpected != null) {
                StringBuilder builder = new StringBuilder();
                if (StringHelper.isNotEmpty((String)failureExpected.message())) {
                    builder.append(failureExpected.message());
                } else {
                    builder.append("ignoring @FailureExpected test");
                }
                builder.append(" (").append(failureExpected.jiraKey()).append(")");
                log.warn((Object)builder.toString(), t);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Method runMethod = this.findTestMethod();
        Skip skip = this.determineSkipByGridDialect(runMethod);
        if (skip != null) {
            this.reportSkip(skip);
            return;
        }
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    public String fullTestName() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.getName();
    }

    private Method findTestMethod() {
        String fName = this.getName();
        OgmTestCase.assertNotNull((Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            OgmTestCase.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            OgmTestCase.fail((String)("Method \"" + fName + "\" should be public"));
        }
        return runMethod;
    }

    public Session openSession() throws HibernateException {
        this.rebuildSessionFactory();
        this.session = this.getSessions().openSession();
        return this.session;
    }

    private void rebuildSessionFactory() {
        if (this.sessions == null) {
            try {
                this.buildConfiguration();
            }
            catch (Exception e) {
                throw new HibernateException((Throwable)e);
            }
        }
    }

    protected void setSessions(SessionFactory sessions) {
        this.sessions = sessions;
    }

    protected SessionFactory getSessions() {
        return this.sessions;
    }

    protected SessionFactoryImplementor sfi() {
        return (SessionFactoryImplementor)this.getSessions();
    }

    protected void runSchemaGeneration() {
    }

    protected void runSchemaDrop() {
        TestHelper.dropSchemaAndDatabase(this.session);
    }

    protected void buildConfiguration() throws Exception {
        this.closeSessionFactory();
        try {
            OgmTestCase.setCfg((Configuration)new OgmConfiguration());
            cfg.setProperty("hibernate.ogm.infinispan.configuration_resourcename", "infinispan-local.xml");
            cfg.setProperty("hibernate.id.new_generator_mappings", "true");
            for (Map.Entry<String, String> entry : TestHelper.getEnvironmentProperties().entrySet()) {
                cfg.setProperty(entry.getKey(), entry.getValue());
            }
            this.configure(cfg);
            if (this.recreateSchema()) {
                cfg.setProperty("hibernate.hbm2ddl.auto", "none");
            }
            for (String aPackage : this.getAnnotatedPackages()) {
                OgmTestCase.getCfg().addPackage(aPackage);
            }
            for (Class<?> aClass : this.getAnnotatedClasses()) {
                OgmTestCase.getCfg().addAnnotatedClass((Class)aClass);
            }
            for (String xmlFile : this.getXmlFiles()) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                OgmTestCase.getCfg().addInputStream(is);
            }
            this.setSessions(OgmTestCase.getCfg().buildSessionFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void handleUnclosedResources() {
        if (this.session != null && this.session.isOpen()) {
            if (this.session.isConnected() && this.session.getTransaction().isActive()) {
                this.session.getTransaction().rollback();
            }
            this.session.close();
            this.session = null;
            OgmTestCase.fail((String)"unclosed session");
        } else {
            this.session = null;
        }
        this.closeSessionFactory();
    }

    private void closeSessionFactory() {
        if (this.sessions != null) {
            if (!this.sessions.isClosed()) {
                TestHelper.dropSchemaAndDatabase(this.sessions);
                this.sessions.close();
                this.sessions = null;
            } else {
                this.sessions = null;
            }
        }
    }

    protected void closeResources() {
        try {
            if (this.session != null && this.session.isOpen()) {
                if (this.session.isConnected() && this.session.getTransaction().isActive()) {
                    this.session.getTransaction().rollback();
                }
                this.session.close();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.closeSessionFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkCleanCache() {
        ((BooleanAssert)Assertions.assertThat((boolean)TestHelper.assertNumberOfEntities(0, this.sessions)).as("Entity cache should be empty")).isTrue();
        ((BooleanAssert)Assertions.assertThat((boolean)TestHelper.assertNumberOfAssociations(0, this.sessions)).as("Association cache should be empty")).isTrue();
    }

    static {
        TestHelper.initializeHelpers();
        log = LoggerFactory.make();
    }

    private static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException() {
            super("Test marked as @FailureExpected, but did not fail!");
        }
    }

    protected static class Skip {
        private final String reason;
        private final String testDescription;

        public Skip(String reason, String testDescription) {
            this.reason = reason;
            this.testDescription = testDescription;
        }
    }
}

