/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.hibernate.ogm.test.type.Bookmark;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.junit.Test;

public class BuiltInTypeTest
extends OgmTestCase {
    private static final Log log = LoggerFactory.make();
    private static final Random RANDOM = new Random();
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS Z");

    @Test
    public void testTypesSupport() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Bookmark b = new Bookmark();
        b.setId("42");
        b.setDescription("Hibernate Site");
        b.setUrl(new URL("http://www.hibernate.org/"));
        BigDecimal weight = new BigDecimal("21.77");
        b.setSiteWeight(weight);
        BigInteger visitCount = new BigInteger("444");
        b.setVisitCount(visitCount);
        b.setFavourite(Boolean.TRUE);
        Byte displayMask = 56;
        b.setDisplayMask(displayMask);
        Date now = new Date(System.currentTimeMillis());
        b.setCreationDate(now);
        b.setDestructionDate(now);
        b.setUpdateDate(now);
        Calendar iCal = Calendar.getInstance();
        iCal.setTimeInMillis(now.getTime());
        b.setCreationCalendar(iCal);
        b.setDestructionCalendar(iCal);
        byte[] blob = new byte[]{49, 50, 51, 52, 53};
        b.setBlob(blob);
        UUID serialNumber = UUID.randomUUID();
        b.setSerialNumber(serialNumber);
        Long userId = RANDOM.nextLong();
        log.info((Object)("User ID created: " + userId));
        b.setUserId(userId);
        Integer stockCount = RANDOM.nextInt();
        b.setStockCount(stockCount);
        session.persist((Object)b);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        b = (Bookmark)session.get(Bookmark.class, (Serializable)((Object)b.getId()));
        BuiltInTypeTest.assertEquals((String)"http://www.hibernate.org/", (String)b.getUrl().toString());
        BuiltInTypeTest.assertEquals((Object)weight, (Object)b.getSiteWeight());
        BuiltInTypeTest.assertEquals((Object)visitCount, (Object)b.getVisitCount());
        BuiltInTypeTest.assertEquals((Object)Boolean.TRUE, (Object)b.isFavourite());
        BuiltInTypeTest.assertEquals((Object)displayMask, (Object)b.getDisplayMask());
        BuiltInTypeTest.assertEquals((String)"serial number incorrect", (Object)serialNumber, (Object)b.getSerialNumber());
        BuiltInTypeTest.assertEquals((String)"user id incorrect", (Object)userId, (Object)b.getUserId());
        BuiltInTypeTest.assertEquals((String)"stock count incorrect", (Object)stockCount, (Object)b.getStockCount());
        BuiltInTypeTest.assertEquals((String)"Creation Date Incorrect", (Object)now, (Object)b.getCreationDate());
        BuiltInTypeTest.assertEquals((String)"Timezone Info Not Correct", (Object)iCal.getTimeZone(), (Object)b.getDestructionCalendar().getTimeZone());
        BuiltInTypeTest.assertEquals((String)"Date info String Not Correct iCal", (String)iCal.getTime().toGMTString(), (String)b.getDestructionCalendar().getTime().toGMTString());
        BuiltInTypeTest.assertEquals((String)"Timezone Info Not Correct", (Object)iCal.getTimeZone(), (Object)b.getDestructionCalendar().getTimeZone());
        BuiltInTypeTest.assertEquals((String)("Date info Not Correct iCal: " + this.DATE_FORMAT.format(iCal.getTime()) + " dest millis: " + b.getDestructionCalendar().getTimeInMillis() + " iCal millis: " + iCal.getTimeInMillis()), (Object)iCal.getTime(), (Object)b.getDestructionCalendar().getTime());
        BuiltInTypeTest.assertEquals((String)"Byte array incorrect length", (int)blob.length, (int)b.getBlob().length);
        BuiltInTypeTest.assertEquals((byte)blob[0], (byte)b.getBlob()[0]);
        BuiltInTypeTest.assertEquals((int)49, (int)b.getBlob()[0]);
        BuiltInTypeTest.assertEquals((int)50, (int)b.getBlob()[1]);
        BuiltInTypeTest.assertEquals((int)51, (int)b.getBlob()[2]);
        BuiltInTypeTest.assertEquals((int)52, (int)b.getBlob()[3]);
        BuiltInTypeTest.assertEquals((int)53, (int)b.getBlob()[4]);
        session.delete((Object)b);
        transaction.commit();
        session.close();
    }

    @Test
    public void testStringMappedTypeSerialisation() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Bookmark b = new Bookmark();
        b.setId("42");
        b.setUrl(new URL("http://www.hibernate.org/"));
        BigDecimal weight = new BigDecimal("21.77");
        b.setSiteWeight(weight);
        BigInteger visitCount = new BigInteger("444");
        b.setVisitCount(visitCount);
        UUID serialNumber = UUID.randomUUID();
        b.setSerialNumber(serialNumber);
        Long userId = RANDOM.nextLong();
        b.setUserId(userId);
        Integer stockCount = RANDOM.nextInt();
        b.setStockCount(stockCount);
        session.persist((Object)b);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        b = (Bookmark)session.get(Bookmark.class, (Serializable)((Object)b.getId()));
        EntityKey key = new EntityKey("Bookmark", new String[]{"id"}, new Object[]{"42"});
        Map entity = TestHelper.extractEntityTuple(this.sessions, key);
        BuiltInTypeTest.assertEquals((String)"Entity visits count incorrect", (String)((String)entity.get("visits_count")), (String)"444");
        BuiltInTypeTest.assertEquals((String)"Entity serial number incorrect", (String)((String)entity.get("serialNumber")), (String)serialNumber.toString());
        BuiltInTypeTest.assertEquals((String)"Entity URL incorrect", (String)((String)entity.get("url")), (String)"http://www.hibernate.org/");
        BuiltInTypeTest.assertEquals((String)"Entity site weight incorrect", (String)((String)entity.get("site_weight")), (String)"21.77");
        BuiltInTypeTest.assertEquals((String)"Entity user id incorrect", entity.get("userId"), (Object)userId);
        BuiltInTypeTest.assertEquals((String)"Entity stock count incorrect", entity.get("stockCount"), (Object)stockCount);
        session.delete((Object)b);
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Bookmark.class};
    }
}

