/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.type;

import java.util.Date;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.ogm.test.type.ExplodingType;
import org.hibernate.ogm.test.type.OverridingTypeDialect;
import org.hibernate.ogm.test.type.Poem;
import org.hibernate.ogm.test.utils.PackagingRule;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Rule;
import org.junit.Test;

public class TypeOverridingInDialectTest {
    @Rule
    public PackagingRule packaging = new PackagingRule("persistencexml/jpajtastandalone-customdialect.xml", Poem.class, OverridingTypeDialect.class, ExplodingType.class, TypeOverridingInDialectTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverriddenTypeInDialect() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"jpajtastandalone");
        TransactionManager transactionManager = JpaTestCase.extractJBossTransactionManager(emf);
        transactionManager.begin();
        EntityManager em = emf.createEntityManager();
        try {
            Poem poem = new Poem();
            poem.setName("L'albatros");
            poem.setPoemSocietyId(UUID.randomUUID());
            poem.setCreation(new Date());
            em.persist((Object)poem);
            transactionManager.commit();
            ((BooleanAssert)Assertions.assertThat((boolean)true).as("Custom type not used")).isFalse();
        }
        catch (RollbackException e) {
            Assertions.assertThat((String)e.getCause().getCause().getMessage()).isEqualTo((Object)"Exploding type");
        }
        finally {
            try {
                transactionManager.rollback();
            }
            catch (Exception e) {}
            em.close();
            TestHelper.dropSchemaAndDatabase(emf);
            emf.close();
        }
    }
}

