/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import org.hibernate.ogm.test.utils.TestableGridDialect;

public enum GridDialectType {
    HASHMAP("org.hibernate.ogm.test.utils.HashMapTestHelper"){

        @Override
        public Class<?> loadTestableGridDialectClass() {
            return null;
        }
    }
    ,
    INFINISPAN("org.hibernate.ogm.test.utils.InfinispanTestHelper"),
    EHCACHE("org.hibernate.ogm.test.utils.EhcacheTestHelper"),
    MONGODB("org.hibernate.ogm.test.utils.MongoDBTestHelper");

    private final String testHelperClassName;

    private GridDialectType(String testHelperClassName) {
        this.testHelperClassName = testHelperClassName;
    }

    public Class<?> loadTestableGridDialectClass() {
        Class<?> classForName = null;
        try {
            classForName = Class.forName(this.testHelperClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return classForName;
    }

    public static GridDialectType valueFromHelperClass(Class<? extends TestableGridDialect> class1) {
        for (GridDialectType type : GridDialectType.values()) {
            if (!type.testHelperClassName.equals(class1.getName())) continue;
            return type;
        }
        throw new IllegalArgumentException(class1 + " is not one of the TestableGridDialect implementation known to " + GridDialectType.class);
    }
}

