/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;
import org.hibernate.ogm.test.utils.TestableGridDialect;

public class MongoDBTestHelper
implements TestableGridDialect {
    private static final Log log;

    private static boolean isNotNull(String mongoHostName) {
        return mongoHostName != null && mongoHostName.length() > 0 && !"null".equals(mongoHostName);
    }

    @Override
    public boolean assertNumberOfEntities(int numberOfEntities, SessionFactory sessionFactory) {
        MongoDBDatastoreProvider provider = MongoDBTestHelper.getProvider(sessionFactory);
        AssociationStorage storage = provider.getAssociationStorage();
        DB db = provider.getDatabase();
        int count = 0;
        for (String collectionName : db.getCollectionNames()) {
            if (collectionName.startsWith("system.") || storage == AssociationStorage.GLOBAL_COLLECTION && collectionName.equals("Associations") || storage == AssociationStorage.COLLECTION && collectionName.startsWith("associations_")) continue;
            count = (int)((long)count + db.getCollection(collectionName).count());
        }
        return count == numberOfEntities;
    }

    @Override
    public boolean assertNumberOfAssociations(int numberOfAssociations, SessionFactory sessionFactory) {
        MongoDBDatastoreProvider provider = MongoDBTestHelper.getProvider(sessionFactory);
        AssociationStorage assocStorage = provider.getAssociationStorage();
        DB db = provider.getDatabase();
        if (assocStorage == AssociationStorage.IN_ENTITY) {
            return true;
        }
        if (assocStorage == AssociationStorage.GLOBAL_COLLECTION) {
            return db.getCollection("Associations").count() == (long)numberOfAssociations;
        }
        if (assocStorage == AssociationStorage.COLLECTION) {
            int count = 0;
            for (String collectionName : db.getCollectionNames()) {
                if (assocStorage != AssociationStorage.COLLECTION || !collectionName.startsWith("associations_")) continue;
                count = (int)((long)count + db.getCollection(collectionName).count());
            }
            return count == numberOfAssociations;
        }
        throw new AssertionFailure("Unknown AssociationStorage approach: " + assocStorage);
    }

    @Override
    public Map<String, Object> extractEntityTuple(SessionFactory sessionFactory, EntityKey key) {
        MongoDBDatastoreProvider provider = MongoDBTestHelper.getProvider(sessionFactory);
        BasicDBObject finder = new BasicDBObject("_id", key.getColumnValues()[0]);
        DBObject result = provider.getDatabase().getCollection(key.getTable()).findOne((DBObject)finder);
        return result.toMap();
    }

    @Override
    public boolean backendSupportsTransactions() {
        return false;
    }

    private static MongoDBDatastoreProvider getProvider(SessionFactory sessionFactory) {
        DatastoreProvider provider = (DatastoreProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(DatastoreProvider.class);
        if (!MongoDBDatastoreProvider.class.isInstance(provider)) {
            throw new RuntimeException("Not testing with MongoDB, cannot extract underlying cache");
        }
        return (MongoDBDatastoreProvider)MongoDBDatastoreProvider.class.cast(provider);
    }

    @Override
    public void dropSchemaAndDatabase(SessionFactory sessionFactory) {
        MongoDBDatastoreProvider provider = MongoDBTestHelper.getProvider(sessionFactory);
        try {
            provider.getDatabase().dropDatabase();
        }
        catch (MongoException ex) {
            throw log.unableToDropDatabase(ex, provider.getDatabase().getName());
        }
    }

    @Override
    public Map<String, String> getEnvironmentProperties() {
        HashMap<String, String> envProps = new HashMap<String, String>(2);
        this.copyFromSystemPropertiesToLocalEnvironment("hibernate.ogm.mongodb.host", envProps);
        this.copyFromSystemPropertiesToLocalEnvironment("hibernate.ogm.mongodb.port", envProps);
        this.copyFromSystemPropertiesToLocalEnvironment("hibernate.ogm.mongodb.username", envProps);
        this.copyFromSystemPropertiesToLocalEnvironment("hibernate.ogm.mongodb.password", envProps);
        return envProps;
    }

    private void copyFromSystemPropertiesToLocalEnvironment(String environmentVariableName, Map<String, String> envProps) {
        String value = System.getProperties().getProperty(environmentVariableName);
        if (value != null && value.length() > 0) {
            envProps.put(environmentVariableName, value);
        }
    }

    static {
        String mongoPort;
        log = LoggerFactory.getLogger();
        String mongoHostName = System.getenv("MONGODB_HOSTNAME");
        if (MongoDBTestHelper.isNotNull(mongoHostName)) {
            System.getProperties().setProperty("hibernate.ogm.mongodb.host", mongoHostName);
        }
        if (MongoDBTestHelper.isNotNull(mongoPort = System.getenv("MONGODB_PORT"))) {
            System.getProperties().setProperty("hibernate.ogm.mongodb.port", mongoPort);
        }
    }
}

