/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.rules.TemporaryFolder;

public class PackagingRule
extends TemporaryFolder {
    private static final ArchivePath persistencePath = ArchivePaths.create((String)"persistence.xml");
    protected static ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
    private final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jtastandalone.jar");
    private final File testPackage;

    public PackagingRule(String persistenceConfResource, Class<?> ... entities) {
        this.archive.addClasses((Class[])entities);
        this.archive.addAsManifestResource(persistenceConfResource, persistencePath);
        try {
            this.testPackage = this.newFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(this.testPackage, true);
    }

    public void before() throws Throwable {
        super.before();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{this.testPackage.toURL()}, originalClassLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public void after() {
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        super.after();
    }
}

