/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils.jpa;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.jpa.HibernateOgmPersistence;
import org.hibernate.ogm.test.utils.BaseOGMTest;
import org.hibernate.ogm.test.utils.TestHelper;
import org.hibernate.ogm.test.utils.jpa.GetterPersistenceUnitInfo;
import org.hibernate.ogm.test.utils.jpa.NoopDatasource;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.junit.After;
import org.junit.Before;

public abstract class JpaTestCase
extends BaseOGMTest {
    private EntityManagerFactory factory;
    private TransactionManager transactionManager;

    public EntityManagerFactory getFactory() {
        return this.factory;
    }

    public abstract Class<?>[] getEntities();

    public TransactionManager getTransactionManager() throws Exception {
        return this.transactionManager;
    }

    @Before
    public void createFactory() throws MalformedURLException {
        GetterPersistenceUnitInfo info = new GetterPersistenceUnitInfo();
        info.setClassLoader(Thread.currentThread().getContextClassLoader());
        info.setExcludeUnlistedClasses(true);
        info.setJtaDataSource(new NoopDatasource());
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> clazz : this.getEntities()) {
            classNames.add(clazz.getName());
        }
        info.setManagedClassNames(classNames);
        info.setNonJtaDataSource(null);
        info.setPersistenceProviderClassName(HibernateOgmPersistence.class.getName());
        info.setPersistenceUnitName("default");
        URL persistenceUnitRootUrl = new File("").toURL();
        info.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        info.setPersistenceXMLSchemaVersion("2.0");
        info.setProperties(new Properties());
        info.setSharedCacheMode(SharedCacheMode.ENABLE_SELECTIVE);
        info.setTransactionType(PersistenceUnitTransactionType.JTA);
        info.setValidationMode(ValidationMode.AUTO);
        info.getProperties().setProperty("hibernate.transaction.jta.platform", JBossStandAloneJtaPlatform.class.getName());
        for (Map.Entry<String, String> entry : TestHelper.getEnvironmentProperties().entrySet()) {
            info.getProperties().setProperty(entry.getKey(), entry.getValue());
        }
        this.refineInfo(info);
        this.factory = new HibernateOgmPersistence().createContainerEntityManagerFactory((PersistenceUnitInfo)info, Collections.EMPTY_MAP);
        this.transactionManager = JpaTestCase.extractJBossTransactionManager(this.factory);
    }

    protected void refineInfo(GetterPersistenceUnitInfo info) {
    }

    public static TransactionManager extractJBossTransactionManager(EntityManagerFactory factory) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)((HibernateEntityManagerFactory)factory).getSessionFactory();
        return ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    protected final void commitOrRollback(boolean operationSuccessfull) throws Exception {
        if (operationSuccessfull) {
            this.getTransactionManager().commit();
        } else {
            this.getTransactionManager().rollback();
        }
    }

    @After
    public void closeFactory() {
        if (this.factory != null) {
            if (this.factory.isOpen()) {
                TestHelper.dropSchemaAndDatabase(this.factory);
                this.factory.close();
                this.factory = null;
            } else {
                this.factory = null;
            }
        }
    }
}

