/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.mongodb.impl.MongoDBDatastoreProvider;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.mongodb.MongoDBAssociationSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoDBTupleSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoHelpers;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;
import org.hibernate.ogm.type.ByteStringType;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.StringCalendarDateType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class MongoDBDialect
implements GridDialect {
    private static final Log log = LoggerFactory.getLogger();
    private static final Integer ONE = 1;
    private static final Pattern DOT_SEPARATOR_PATTERN = Pattern.compile("\\.");
    public static final String ID_FIELDNAME = "_id";
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String SEQUENCE_VALUE = "sequence_value";
    public static final String ROWS_FIELDNAME = "rows";
    public static final String TABLE_FIELDNAME = "table";
    public static final String ASSOCIATIONS_COLLECTION_PREFIX = "associations_";
    private static final List<String> ROWS_FIELDNAME_LIST = Collections.singletonList("rows");
    private final MongoDBDatastoreProvider provider;
    private final DB currentDB;

    public MongoDBDialect(MongoDBDatastoreProvider provider) {
        this.provider = provider;
        this.currentDB = this.provider.getDatabase();
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        throw new UnsupportedOperationException("The MongoDB GridDialect does not support locking");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        DBObject found = this.getObject(key, tupleContext);
        return found != null ? new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(found, key)) : null;
    }

    public Tuple createTuple(EntityKey key) {
        BasicDBObject toSave = this.prepareIdObject(key);
        return new Tuple((TupleSnapshot)new MongoDBTupleSnapshot((DBObject)toSave, key));
    }

    private DBObject getObjectAsEmbeddedAssociation(AssociationKey key) {
        DBCollection collection = this.getCollection(key.getEntityKey());
        BasicDBObject searchObject = this.prepareIdObject(key.getEntityKey());
        DBObject restrictionObject = this.getSearchObject(key, true);
        return collection.findOne((DBObject)searchObject, restrictionObject);
    }

    private DBObject getObject(EntityKey key, TupleContext tupleContext) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject searchObject = this.prepareIdObject(key);
        BasicDBObject restrictionObject = this.getSearchObject(tupleContext);
        return collection.findOne((DBObject)searchObject, (DBObject)restrictionObject);
    }

    private BasicDBObject getSearchObject(TupleContext tupleContext) {
        return this.getSearchObject(tupleContext.getSelectableColumns());
    }

    private BasicDBObject getSearchObject(List<String> selectedColumns) {
        BasicDBObject searchObject = new BasicDBObject();
        for (String column : selectedColumns) {
            searchObject.append(column, (Object)1);
        }
        return searchObject;
    }

    private BasicDBObject prepareIdObject(EntityKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(RowKey key) {
        return this.prepareIdObject(key.getColumnNames(), key.getColumnValues());
    }

    private BasicDBObject prepareIdObject(String[] columnNames, Object[] columnValues) {
        BasicDBObject object;
        if (columnNames.length == 1) {
            object = new BasicDBObject(ID_FIELDNAME, columnValues[0]);
        } else {
            object = new BasicDBObject();
            BasicDBObject idObject = new BasicDBObject();
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                Object columnValue = columnValues[i];
                if (columnName.contains(PROPERTY_SEPARATOR)) {
                    int dotIndex = columnName.indexOf(PROPERTY_SEPARATOR);
                    String shortColumnName = columnName.substring(dotIndex + 1);
                    idObject.put(shortColumnName, columnValue);
                    continue;
                }
                idObject.put(columnNames[i], columnValue);
            }
            object.put(ID_FIELDNAME, (Object)idObject);
        }
        return object;
    }

    private DBCollection getCollection(String table) {
        return this.currentDB.getCollection(table);
    }

    private DBCollection getCollection(EntityKey key) {
        return this.getCollection(key.getTable());
    }

    private DBCollection getAssociationCollection(AssociationKey key) {
        switch (this.provider.getAssociationStorage()) {
            case GLOBAL_COLLECTION: {
                return this.getCollection("Associations");
            }
            case COLLECTION: {
                return this.getCollection(ASSOCIATIONS_COLLECTION_PREFIX + key.getTable());
            }
        }
        throw new AssertionFailure("Unknown AssociationStorage: " + (Object)((Object)this.provider.getAssociationStorage()));
    }

    private BasicDBObject getSubQuery(String operator, BasicDBObject query) {
        return query.get(operator) != null ? (BasicDBObject)query.get(operator) : new BasicDBObject();
    }

    private void addSubQuery(String operator, BasicDBObject query, String column, Object value) {
        BasicDBObject subQuery = this.getSubQuery(operator, query);
        query.append(operator, (Object)subQuery.append(column, value));
    }

    public void updateTuple(Tuple tuple, EntityKey key) {
        MongoDBTupleSnapshot snapshot = (MongoDBTupleSnapshot)tuple.getSnapshot();
        BasicDBObject updater = new BasicDBObject();
        for (TupleOperation operation : tuple.getOperations()) {
            String column = operation.getColumn();
            if (column.equals(ID_FIELDNAME) || column.endsWith("._id") || snapshot.columnInIdField(column)) continue;
            switch (operation.getType()) {
                case PUT_NULL: 
                case PUT: {
                    this.addSubQuery("$set", updater, column, operation.getValue());
                    break;
                }
                case REMOVE: {
                    this.addSubQuery("$unset", updater, column, ONE);
                }
            }
        }
        BasicDBObject idObject = this.prepareIdObject(key);
        if (updater.size() == 0) {
            updater = idObject;
        }
        this.getCollection(key).update((DBObject)idObject, (DBObject)updater, true, false);
    }

    public void removeTuple(EntityKey key) {
        DBCollection collection = this.getCollection(key);
        BasicDBObject toDelete = this.prepareIdObject(key);
        collection.remove((DBObject)toDelete);
    }

    private DBObject findAssociation(AssociationKey key) {
        DBObject associationKeyObject = MongoHelpers.associationKeyToObject(this.provider.getAssociationStorage(), key);
        return this.getAssociationCollection(key).findOne(associationKeyObject, this.getSearchObject(key, false));
    }

    private DBObject getSearchObject(AssociationKey key, boolean embedded) {
        if (embedded) {
            return this.getSearchObject(Collections.singletonList(key.getCollectionRole()));
        }
        return this.getSearchObject(ROWS_FIELDNAME_LIST);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        if (MongoHelpers.isEmbeddedInEntity(key, this.provider.getAssociationStorage())) {
            DBObject entity = this.getObjectAsEmbeddedAssociation(key);
            if (this.getAssociationFieldOrNull(key, entity) != null) {
                return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, this.provider.getAssociationStorage()));
            }
            return null;
        }
        DBObject result = this.findAssociation(key);
        if (result == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(result, key, this.provider.getAssociationStorage()));
    }

    private DBObject getAssociationFieldOrNull(AssociationKey key, DBObject entity) {
        String[] path = DOT_SEPARATOR_PATTERN.split(key.getCollectionRole());
        DBObject field = entity;
        for (String node : path) {
            field = field != null ? (DBObject)field.get(node) : null;
        }
        return field;
    }

    public Association createAssociation(AssociationKey key) {
        if (MongoHelpers.isEmbeddedInEntity(key, this.provider.getAssociationStorage())) {
            DBObject entity = this.getObjectAsEmbeddedAssociation(key);
            boolean insert = false;
            if (entity == null) {
                insert = true;
                entity = this.prepareIdObject(key.getEntityKey());
            }
            if (this.getAssociationFieldOrNull(key, entity) == null) {
                if (insert) {
                    MongoHelpers.addEmptyAssociationField(key, entity);
                    this.getCollection(key.getEntityKey()).insert(new DBObject[]{entity});
                } else {
                    BasicDBObject updater = new BasicDBObject();
                    this.addSubQuery("$set", updater, key.getCollectionRole(), Collections.EMPTY_LIST);
                    this.getCollection(key.getEntityKey()).update(entity, (DBObject)updater, true, false);
                    MongoHelpers.addEmptyAssociationField(key, entity);
                }
            }
            return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(entity, key, this.provider.getAssociationStorage()));
        }
        DBCollection associations = this.getAssociationCollection(key);
        DBObject assoc = MongoHelpers.associationKeyToObject(this.provider.getAssociationStorage(), key);
        assoc.put(ROWS_FIELDNAME, (Object)Collections.EMPTY_LIST);
        associations.insert(new DBObject[]{assoc});
        return new Association((AssociationSnapshot)new MongoDBAssociationSnapshot(assoc, key, this.provider.getAssociationStorage()));
    }

    private DBObject removeAssociationRowKey(MongoDBAssociationSnapshot snapshot, RowKey rowKey, String associationField) {
        BasicDBObject pull = new BasicDBObject(associationField, (Object)snapshot.getRowKeyDBObject(rowKey));
        return new BasicDBObject("$pull", (Object)pull);
    }

    private DBObject putAssociationRowKey(Tuple value, String associationField, AssociationKey associationKey) {
        BasicDBObject rowTupleMap = new BasicDBObject();
        for (String valueKeyName : value.getColumnNames()) {
            boolean add = true;
            for (String assocColumn : associationKey.getColumnNames()) {
                if (!valueKeyName.equals(assocColumn)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            rowTupleMap.put(valueKeyName, value.get(valueKeyName));
        }
        BasicDBObject row = rowTupleMap;
        return new BasicDBObject("$push", (Object)new BasicDBObject(associationField, (Object)row));
    }

    public void updateAssociation(Association association, AssociationKey key) {
        String associationField;
        DBObject query;
        DBCollection collection;
        MongoDBAssociationSnapshot assocSnapshot = (MongoDBAssociationSnapshot)association.getSnapshot();
        if (MongoHelpers.isEmbeddedInEntity(key, this.provider.getAssociationStorage())) {
            collection = this.getCollection(key.getEntityKey());
            query = this.prepareIdObject(key.getEntityKey());
            associationField = key.getCollectionRole();
        } else {
            collection = this.getAssociationCollection(key);
            query = assocSnapshot.getQueryObject();
            associationField = ROWS_FIELDNAME;
        }
        for (AssociationOperation action : association.getOperations()) {
            RowKey rowKey = action.getKey();
            Tuple rowValue = action.getValue();
            DBObject update = null;
            switch (action.getType()) {
                case CLEAR: {
                    update = new BasicDBObject("$set", (Object)new BasicDBObject(associationField, (Object)Collections.EMPTY_LIST));
                    break;
                }
                case PUT_NULL: 
                case PUT: {
                    update = this.putAssociationRowKey(rowValue, associationField, key);
                    break;
                }
                case REMOVE: {
                    update = this.removeAssociationRowKey(assocSnapshot, rowKey, associationField);
                }
            }
            if (update == null) continue;
            collection.update(query, update, true, false);
        }
    }

    public void removeAssociation(AssociationKey key) {
        if (MongoHelpers.isEmbeddedInEntity(key, this.provider.getAssociationStorage())) {
            BasicDBObject entity = this.prepareIdObject(key.getEntityKey());
            if (entity != null) {
                BasicDBObject updater = new BasicDBObject();
                this.addSubQuery("$unset", updater, key.getCollectionRole(), ONE);
                this.getCollection(key.getEntityKey()).update((DBObject)entity, (DBObject)updater, true, false);
            }
        } else {
            DBCollection collection = this.getAssociationCollection(key);
            DBObject query = MongoHelpers.associationKeyToObject(this.provider.getAssociationStorage(), key);
            int nAffected = collection.remove(query).getN();
            log.removedAssociation(nAffected);
        }
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple(EmptyTupleSnapshot.SINGLETON);
    }

    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        Object idFromDB;
        DBCollection currentCollection = this.currentDB.getCollection(key.getTable());
        BasicDBObject query = this.prepareIdObject(key);
        BasicDBObject update = new BasicDBObject();
        Integer incrementObject = increment == 1 ? ONE : Integer.valueOf(increment);
        this.addSubQuery("$inc", update, SEQUENCE_VALUE, incrementObject);
        DBObject result = currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, true);
        Object object = idFromDB = result == null ? null : result.get(SEQUENCE_VALUE);
        if (idFromDB == null) {
            BasicDBObject updateForInitial = new BasicDBObject();
            this.addSubQuery("$inc", updateForInitial, SEQUENCE_VALUE, initialValue);
            currentCollection.findAndModify((DBObject)query, null, null, false, (DBObject)updateForInitial, false, true);
            idFromDB = initialValue;
        } else {
            idFromDB = result.get(SEQUENCE_VALUE);
        }
        if (!idFromDB.getClass().equals(Integer.class) && !idFromDB.getClass().equals(Long.class)) {
            throw new HibernateException("Cannot increment a non numeric field");
        }
        Number id = (Number)idFromDB;
        value.initialize(id.longValue());
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.CALENDAR || type == StandardBasicTypes.CALENDAR_DATE) {
            return StringCalendarDateType.INSTANCE;
        }
        if (type == StandardBasicTypes.BYTE) {
            return ByteStringType.INSTANCE;
        }
        return null;
    }
}

