/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb;

import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoHelpers;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;

public class MongoDBTupleSnapshot
implements TupleSnapshot {
    public static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private final DBObject dbObject;
    private final RowKey rowKey;
    private final EntityKey entityKey;
    private final List<String> columnNames;

    public MongoDBTupleSnapshot(DBObject dbObject, RowKey rowKey) {
        this.dbObject = dbObject;
        this.rowKey = rowKey;
        this.entityKey = null;
        this.columnNames = null;
    }

    public MongoDBTupleSnapshot(DBObject dbObject, EntityKey entityKey) {
        this.dbObject = dbObject;
        this.entityKey = entityKey;
        this.columnNames = Arrays.asList(entityKey.getColumnNames());
        this.rowKey = null;
    }

    public Object get(String column) {
        Object result;
        if (this.rowKey != null && !this.isEmpty() && (result = MongoHelpers.getValueFromColumns(column, this.rowKey.getColumnNames(), this.rowKey.getColumnValues())) != null) {
            return result;
        }
        if (column.contains(".")) {
            String[] fields = EMBEDDED_FIELDNAME_SEPARATOR.split(column, 0);
            return this.getObject(this.dbObject.toMap(), fields, 0);
        }
        return this.dbObject.get(column);
    }

    public Set<String> getColumnNames() {
        Set<String> columns = this.dbObject.toMap().keySet();
        if (this.rowKey != null && !this.isEmpty()) {
            columns = new HashSet<String>(columns);
            for (String column : this.rowKey.getColumnNames()) {
                columns.add(column);
            }
        }
        return columns;
    }

    public DBObject getDbObject() {
        return this.dbObject;
    }

    private Object getObject(Map<?, ?> fields, String[] remainingFields, int startIndex) {
        if (startIndex == remainingFields.length - 1) {
            return fields.get(remainingFields[startIndex]);
        }
        Map subMap = (Map)fields.get(remainingFields[startIndex]);
        if (subMap != null) {
            return this.getObject(subMap, remainingFields, ++startIndex);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.dbObject.keySet().isEmpty();
    }

    public boolean columnInIdField(String column) {
        return this.columnNames == null ? false : this.columnNames.contains(column);
    }
}

