/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing;

import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.dialect.mongodb.query.MongoDBQueryImpl;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBProcessingChain;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBQueryParsingResult;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;
import org.hibernate.ogm.service.impl.BaseQueryParserService;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;

public class MongoDBBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.getLogger();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    public Query getParsedQueryExecutor(OgmSession session, String queryString, Map<String, Object> namedParameters) {
        QueryParser queryParser = new QueryParser();
        MongoDBProcessingChain processingChain = this.createProcessingChain((Session)session, this.unwrap(namedParameters));
        MongoDBQueryParsingResult result = (MongoDBQueryParsingResult)queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
        log.createdQuery(queryString, result);
        return new MongoDBQueryImpl(result.getEntityType(), result.getQuery(), result.getProjection(), session);
    }

    private MongoDBProcessingChain createProcessingChain(Session session, Map<String, Object> namedParameters) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames(session.getSessionFactory());
        return new MongoDBProcessingChain((SessionFactoryImplementor)session.getSessionFactory(), entityNamesResolver, namedParameters);
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }
}

