/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBPropertyHelper;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBQueryParsingResult;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBQueryRendererDelegate;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBQueryResolverDelegate;

public class MongoDBProcessingChain
implements AstProcessingChain<MongoDBQueryParsingResult> {
    private final QueryResolverProcessor resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)new MongoDBQueryResolverDelegate());
    private final QueryRendererProcessor rendererProcessor;
    private final MongoDBQueryRendererDelegate rendererDelegate;

    public MongoDBProcessingChain(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        MongoDBPropertyHelper propertyHelper = new MongoDBPropertyHelper(sessionFactory, entityNames);
        MongoDBQueryRendererDelegate rendererDelegate = new MongoDBQueryRendererDelegate(entityNames, propertyHelper, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)rendererDelegate);
        this.rendererDelegate = rendererDelegate;
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public MongoDBQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }
}

