/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBPredicateFactory;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBPropertyHelper;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBQueryParsingResult;

public class MongoDBQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<DBObject, MongoDBQueryParsingResult> {
    private final MongoDBPropertyHelper propertyHelper;

    public MongoDBQueryRendererDelegate(EntityNamesResolver entityNames, MongoDBPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super(entityNames, SingleEntityQueryBuilder.getInstance((PredicateFactory)new MongoDBPredicateFactory(propertyHelper), (PropertyHelper)propertyHelper), namedParameters);
        this.propertyHelper = propertyHelper;
    }

    public MongoDBQueryParsingResult getResult() {
        return new MongoDBQueryParsingResult(this.targetType, (DBObject)this.builder.build(), this.getProjectionDBObject());
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && !propertyPath.getLastNode().isAlias() || propertyPath.getNodes().size() == 2 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, propertyPath.asStringPathWithoutAlias()));
            } else if (propertyPath.getNodes().size() != 1) {
                throw new UnsupportedOperationException("Selecting nested/associated properties not yet implemented.");
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private DBObject getProjectionDBObject() {
        BasicDBObject projectionDBObject = new BasicDBObject();
        for (String projection : this.projections) {
            projectionDBObject.put(projection, (Object)1);
        }
        return projectionDBObject;
    }
}

