/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.logging.mongodb.impl;

import com.mongodb.MongoException;
import org.hibernate.HibernateException;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1201, value="Connecting to MongoDB at %1$s:%2$d with a timeout set at %3$d millisecond(s)")
    public void connectingToMongo(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1202, value="Closing connection to MongoDB")
    public void disconnectingFromMongo();

    @Message(id=1203, value="Unable to find or initialize a connection to the MongoDB server")
    public HibernateException unableToInitializeMongoDB(@Cause RuntimeException var1);

    @Message(id=1204, value="The value set for the configuration property 'hibernate.ogm.mongodb.port' must be a number between 1 and 65535. Found '[%s]'.")
    public HibernateException mongoPortIllegalValue(String var1);

    @Message(id=1205, value="Could not resolve MongoDB hostname [%s]")
    public HibernateException mongoOnUnknownHost(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1206, value="Mongo database named [%s] is not defined. Creating it!")
    public void creatingDatabase(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1207, value="Connecting to Mongo database named [%s].")
    public void connectingToMongoDatabase(String var1);

    @Message(id=1208, value="The configuration property 'hibernate.ogm.mongodb.database' was not set. Can't connect to MongoDB.")
    public HibernateException mongoDbNameMissing();

    @Message(id=1209, value="The database named [%s] cannot be dropped")
    public HibernateException unableToDropDatabase(@Cause MongoException var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1210, value="Removed [%d] associations")
    public void removedAssociation(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1211, value="The configuration property 'hibernate.ogm.mongodb.writeconcern' is set to %s")
    public void useWriteConcern(String var1);

    @Message(id=1212, value="Unknown association storage strategy: [%s]. Supported values in enum %s")
    public HibernateException unknownAssociationStorageStrategy(String var1, Class<?> var2);

    @Message(id=1213, value="MongoDB authentication failed with username [%s]")
    public HibernateException authenticationFailed(String var1);

    @Message(id=1214, value="Unable to connect to MongoDB instance %1$s:%2$d")
    public HibernateException unableToConnectToDatastore(String var1, int var2, @Cause Exception var3);

    @Message(id=1215, value="The value set for the configuration propertyhibernate.ogm.mongodb.connection_timeout must be a number greater than 0. Found '[%s]'.")
    public HibernateException mongoDBTimeOutIllegalValue(String var1);

    @Message(id=1216, value="'%s' cannot be set as an available value for hibernate.ogm.mongodb.writeconcern you must choose between [ACKNOWLEDGED, ERRORS_IGNORED, FSYNC_IGNORED, UNACKNOWLEDGED, FSYNCED, JOURNALED, REPLICA_ACKNOWLEDGED,NONE, NORMAL, SAFE, MAJORITY, FSYNC_SAFE, JOURNAL_SAFE, REPLICAS_SAFE]")
    public HibernateException unableToSetWriteConcern(String var1);

    @Message(id=1217, value="The result of a native query in MongoDB must be mapped by an entity")
    public HibernateException requireMetadatas();
}

