/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * JBoss, Home of Professional Open Source
 * Copyright 2014 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.hibernate.ogm.datastore.mongodb.options.impl;

import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.options.WriteConcern;
import org.hibernate.ogm.datastore.mongodb.options.WriteConcernType;
import org.hibernate.ogm.options.spi.AnnotationConverter;
import org.hibernate.ogm.options.spi.OptionValuePair;

/**
 * Converts {@link WriteConcern} instances into an equivalent option value pair.
 *
 * @author Gunnar Morling
 */
public class WriteConcernConverter implements AnnotationConverter<WriteConcern> {

	private static final Log log = LoggerFactory.getLogger();

	@Override
	public OptionValuePair<?> convert(WriteConcern annotation) {
		com.mongodb.WriteConcern writeConcern = null;

		if ( annotation.value() == WriteConcernType.CUSTOM ) {
			try {
				writeConcern = annotation.type().newInstance();
			}
			catch (Exception e) {
				throw log.unableToInstantiateType( annotation.type().getName(), e );
			}
		}
		else {
			writeConcern = annotation.value().getWriteConcern();
		}

		return OptionValuePair.getInstance( new WriteConcernOption(), writeConcern );
	}
}
