/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.mongodb.MongoDBDialect;
import org.hibernate.ogm.datastore.mongodb.impl.configuration.MongoDBConfiguration;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBBasedQueryParserService;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class MongoDBDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Log log = LoggerFactory.getLogger();
    private ServiceRegistryImplementor serviceRegistry;
    private MongoClient mongo;
    private DB mongoDb;
    private MongoDBConfiguration config;

    public MongoDBDatastoreProvider() {
    }

    public MongoDBDatastoreProvider(MongoClient mongoClient) {
        this.mongo = mongoClient;
    }

    public void configure(Map configurationValues) {
        OptionsService optionsService = (OptionsService)this.serviceRegistry.getService(OptionsService.class);
        ClassLoaderService classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, classLoaderService);
        this.config = new MongoDBConfiguration(propertyReader, optionsService.context().getGlobalOptions());
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return MongoDBDialect.class;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return MongoDBBasedQueryParserService.class;
    }

    public void start() {
        if (this.mongo == null) {
            try {
                ServerAddress serverAddress = new ServerAddress(this.config.getHost(), this.config.getPort());
                MongoClientOptions clientOptions = this.config.buildOptions();
                log.connectingToMongo(this.config.getHost(), this.config.getPort(), clientOptions.getConnectTimeout());
                this.mongo = new MongoClient(serverAddress, clientOptions);
            }
            catch (UnknownHostException e) {
                throw log.mongoOnUnknownHost(this.config.getHost());
            }
            catch (RuntimeException e) {
                throw log.unableToInitializeMongoDB(e);
            }
        }
        this.mongoDb = this.extractDatabase();
    }

    public void stop() {
        log.disconnectingFromMongo();
        this.mongo.close();
    }

    public DB getDatabase() {
        return this.mongoDb;
    }

    private DB extractDatabase() {
        try {
            DB admin;
            boolean auth;
            if (this.config.getUsername() != null && !(auth = (admin = this.mongo.getDB("admin")).authenticate(this.config.getUsername(), this.config.getPassword().toCharArray()))) {
                throw log.authenticationFailed(this.config.getUsername());
            }
            String databaseName = this.config.getDatabaseName();
            log.connectingToMongoDatabase(databaseName);
            if (!this.mongo.getDatabaseNames().contains(databaseName)) {
                log.creatingDatabase(databaseName);
            }
            return this.mongo.getDB(databaseName);
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw log.unableToConnectToDatastore(this.config.getHost(), this.config.getPort(), e);
        }
    }
}

